#version 300 es

precision mediump float;

out vec4 fragColor;

uniform sampler2D u_tex0;
uniform float u_finalAlpha;

const float u_minBlur = 0.1;
const float u_maxBlur = 0.15;
const float u_alpha = 0.6;
const float u_particleYThreshold = 0.8;

in float v_blur;
in float v_alpha;
in float v_type;
in float v_y;
in vec2 v_texCoord0;

void main() {
    if(v_texCoord0.y >= u_particleYThreshold){
        discard;
    }

    float blurX = distance(gl_PointCoord.xy, vec2(0.5, 0.5)) * 2.0;
    blurX = min(1.0, blurX);

    float blurY = u_minBlur + (u_maxBlur - u_minBlur) * v_blur;
    blurY = min(1.0, blurY);

    float alpha = texture(u_tex0, vec2(blurX, blurY)).r;
    vec3 darkColor = vec3(0.4, 0.32, 0.16);//vec3(0.51, 0.35, 0.04)
    float strength = smoothstep(u_particleYThreshold * 0.9, u_particleYThreshold, v_texCoord0.y);
    darkColor *= strength;

    if(v_type < 0.07){
        fragColor = vec4(darkColor, alpha * v_alpha * u_alpha * v_y * 0.2);
    } else {
        fragColor = vec4(darkColor, alpha * v_alpha * u_alpha * v_y);
    }

    fragColor.a *= u_finalAlpha;
}