#version 300 es

in vec3 a_position;
in vec2 a_texCoord0;
in float a_size;
in float a_alpha;
in float a_random;
in float a_start;
in float a_speed_random;

uniform float u_time;
uniform mat4 u_projViewTrans;
uniform mat4 u_viewTrans;
uniform float u_camZ;
uniform float u_farClip;
uniform float u_disturbance;
uniform float u_sandSpeedX;
uniform float u_sandSpeedY;
uniform float u_pointSizeScale;

const float u_maxPointSize = 36.0;
const float u_exp = 10.0;
const float u_size = 150.0;
const float u_focalWidth = 0.18;
const float u_focalDistance = 0.7;
const float u_peak = 3.0;
const float u_random = 2.0;
const float u_speed = 8.0;
const float u_range = 0.6;

out vec2 v_texCoord0;

float rand(vec2 c){
    return fract(sin(dot(c.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec4 mod289(vec4 x) {
    return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 permute(vec4 x) {
  return mod289(((x*34.0)+1.0)*x);
}

vec4 taylorInvSqrt(vec4 r) {
  return 1.79284291400159 - 0.85373472095314 * r;
}

vec2 fade(vec2 t) {
    return t*t*t*(t*(t*6.0-15.0)+10.0);
}

// Classic Perlin noise
float cnoise(vec2 P) {
    vec4 Pi = floor(P.xyxy) + vec4(0.0, 0.0, 1.0, 1.0);
    vec4 Pf = fract(P.xyxy) - vec4(0.0, 0.0, 1.0, 1.0);
    Pi = mod289(Pi); // To avoid truncation effects in permutation
    vec4 ix = Pi.xzxz;
    vec4 iy = Pi.yyww;
    vec4 fx = Pf.xzxz;
    vec4 fy = Pf.yyww;

    vec4 i = permute(permute(ix) + iy);

    vec4 gx = fract(i * (1.0 / 41.0)) * 2.0 - 1.0 ;
    vec4 gy = abs(gx) - 0.5 ;
    vec4 tx = floor(gx + 0.5);
    gx = gx - tx;

    vec2 g00 = vec2(gx.x,gy.x);
    vec2 g10 = vec2(gx.y,gy.y);
    vec2 g01 = vec2(gx.z,gy.z);
    vec2 g11 = vec2(gx.w,gy.w);

    vec4 norm = taylorInvSqrt(vec4(dot(g00, g00), dot(g01, g01), dot(g10, g10), dot(g11, g11)));
    g00 *= norm.x;
    g01 *= norm.y;
    g10 *= norm.z;
    g11 *= norm.w;

    float n00 = dot(g00, vec2(fx.x, fy.x));
    float n10 = dot(g10, vec2(fx.y, fy.y));
    float n01 = dot(g01, vec2(fx.z, fy.z));
    float n11 = dot(g11, vec2(fx.w, fy.w));

    vec2 fade_xy = fade(Pf.xy);
    vec2 n_x = mix(vec2(n00, n01), vec2(n10, n11), fade_xy.x);
    float n_xy = mix(n_x.x, n_x.y, fade_xy.y);
    return 2.3 * n_xy;
}

float map(float value, float oldMin, float oldMax, float newMin, float newMax) {
    return newMin + (newMax - newMin) * (value - oldMin) / (oldMax - oldMin);
}

out float v_blur;
out float v_alpha;
out float v_type;
out float v_y;

float getBlurFactor(float depth) {
	return smoothstep(0.0, u_focalWidth, abs(u_focalDistance - (depth * u_farClip)));
}

void main() {
    v_texCoord0 = a_position.xy * 0.1;

    float deltaTime  = u_time - a_start;
    vec2 uv = a_position.xy * 0.1 + a_random * u_random;
    v_alpha = a_alpha;

    vec3 newPos = a_position;
    vec2 peak = vec2(1.0 - abs(0.5 - uv.x), 1.0 - abs(0.5 - uv.y));
    vec2 noise = vec2(
        map(cnoise(vec2(0.01 * u_speed * u_time + uv.x * 5., uv.y * 5.)), -1., 1., 0., (peak.x * peak.y * 30.)),
        map(cnoise(vec2(-0.01 * u_speed * u_time + uv.x * 5., uv.y * 5.)), -1., 1., 0., 30.)
    );

    //newPos.x += noise.x * 10.;
    newPos.x += noise.x * 0.03;
    newPos.y += noise.y * u_disturbance + 0.5;
    newPos.z += (noise.x + noise.y) * .002 * u_peak;
    v_y = map(newPos.y, u_range, -u_range, 1.0, 0.0);

    vec3 positionVS = (u_viewTrans * vec4(newPos, 1.0)).xyz;
    float depth = -positionVS.z / u_farClip;
    v_blur = getBlurFactor(depth);

    v_type = a_random;
    float size;
    if(v_type < 0.07){
        size = a_size * u_size * 2.0 * u_pointSizeScale;
        v_blur *= 0.6 ;
    }else{
        // apply scale on this case may product samll dust, will shaking
        size = a_size * 0.89 + 0.11;
        size *= u_size;
    }
    // apply size scale to maxSize, dust is too small, so adjust it by 0.4/0.6 coef
    size = clamp(size, 0.0, u_maxPointSize * (0.4 + 0.6 * u_pointSizeScale));

    newPos.x -= deltaTime * u_sandSpeedX * a_speed_random;
    newPos.y -= deltaTime * u_sandSpeedY;
    v_alpha *= smoothstep(-0.05, 0.15, newPos.y);

    gl_PointSize = size;
    gl_Position = u_projViewTrans * vec4( newPos, 1.0 );
}