#version 300 es
precision highp float;

uniform float u_time;
uniform float u_aspect;
uniform float u_alpha;

const float X_SCALE = 0.1;
const float Y_SCALE = 0.1;
const float MOVE_SPEED = 1.0;
const float CHANGE_SPEED = 5.768;
const float COLOR_MIN = -0.2;
const float COLOR_MAX = 1.1;
uniform sampler2D u_texDither;
out vec4 fragColor;
in highp vec2 v_texCoord0;
vec3 random3(vec3 c) {
    float j = 4096.0*sin(dot(c, vec3(17.0, 59.4, 15.0)));
    vec3 r;
    r.z = fract(512.0*j);
    j *= .125;
    r.x = fract(512.0*j);
    j *= .125;
    r.y = fract(512.0*j);
    return r - 0.5;
}

const float F3 = 0.3333333;
const float G3 = 0.1666667;


float map(float value, float oldMin, float oldMax, float newMin, float newMax) {
    return newMin + (newMax - newMin) * (value - oldMin) / (oldMax - oldMin);
}

vec4 permute(vec4 x) {
    return mod(((x * 34.0) + 1.0) * x, 289.0);
}

float simplex(vec3 v) {
    const vec2 C = vec2(1.0 / 6.0, 1.0 / 3.0);
    const vec4 D = vec4(0.0, 0.5, 1.0, 2.0);

    vec3 i = floor(v + dot(v, C.yyy));
    vec3 x0 = v - i + dot(i, C.xxx);

    vec3 g = step(x0.yzx, x0.xyz);
    vec3 l = 1.0 - g;
    vec3 i1 = min(g.xyz, l.zxy);
    vec3 i2 = max(g.xyz, l.zxy);

    vec3 x1 = x0 - i1 + C.xxx;
    vec3 x2 = x0 - i2 + C.yyy;
    vec3 x3 = x0 - D.yyy;

    i = mod(i, 289.0);
    vec4 p = permute(permute(permute(
             i.z + vec4(0.0, i1.z, i2.z, 1.0))
           + i.y + vec4(0.0, i1.y, i2.y, 1.0))
           + i.x + vec4(0.0, i1.x, i2.x, 1.0));

    float n_ = 0.142857142857;
    vec3 ns = n_ * D.wyz - D.xzx;

    vec4 j = p - 49.0 * floor(p * ns.z * ns.z);

    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - 7.0 * x_);

    vec4 x = x_ * ns.x + ns.yyyy;
    vec4 y = y_ * ns.x + ns.yyyy;
    vec4 h = 1.0 - abs(x) - abs(y);

    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);

    vec4 s0 = floor(b0) * 2.0 + 1.0;
    vec4 s1 = floor(b1) * 2.0 + 1.0;
    vec4 sh = -step(h, vec4(0.0));

    vec4 a0 = b0.xzyw + s0.xzyw * sh.xxyy;
    vec4 a1 = b1.xzyw + s1.xzyw * sh.zzww;

    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);

    vec4 norm = inversesqrt(vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3)));
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;

    vec4 m = max(0.6 - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), 0.0);
    m = m * m;
    return 42.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}


float snoiseFractal(vec3 m) {
    return 0.5333333 * simplex(m)
    + 0.2666667 * simplex(2.0*m)
    + 0.1333333 * simplex(4.0*m)
    + 0.0666667 * simplex(8.0*m);
}

float rand(vec2 c){
    return fract(sin(dot(c.xy, vec2(12.9898, 78.233))) * 43759.361);
}

float blendOverlay(float base, float blend) {
    return base<0.5?(2.0*base*blend):(1.0-2.0*(1.0-base)*(1.0-blend));
}

vec3 blendOverlay(vec3 base, vec3 blend) {
    return vec3(blendOverlay(base.r,blend.r),blendOverlay(base.g,blend.g),blendOverlay(base.b,blend.b));
}

vec3 blendOverlay(vec3 base, vec3 blend, float opacity) {
    return (blendOverlay(base, blend) * opacity + base * (1.0 - opacity));
}

void main() {
    vec2 st0 = vec2(v_texCoord0.x, -v_texCoord0.y);
    st0.y /= u_aspect;

    float red;

    vec2 st2 = st0;
    st2 *= 0.12;
    st2.x -= u_time * 0.05 * MOVE_SPEED+ 1.744;
    red = map(snoiseFractal(vec3(st2.x*3.0, st2.y*3.0, 1.0)), -1.0, 1.0, COLOR_MIN, COLOR_MAX);
    red *= red;
    red += mix(-0.004, 0.004, rand(st2));

    float noise = texture(u_texDither, v_texCoord0 * vec2(16.875, 18.281)).r;

    mediump float strength = smoothstep(0.4, 0.6, 1.0-v_texCoord0.y);
    fragColor = vec4(0.1 + vec3(0.5 * red), strength);
    vec3 final = blendOverlay(vec3(0.3), vec3(red) * (0.5 + noise * 0.08), 0.5);
    fragColor = vec4(final, strength + noise * 0.05);
    fragColor *= u_alpha;
}