#version 300 es

precision mediump float;

uniform sampler2D u_texLast;
uniform sampler2D u_texNew;

const float ALPHA_DECREASE = 0.15;

in highp vec2 v_texCoord0;

out vec4 fragColor;

void main() {
    vec4 color0 = texture(u_texLast, v_texCoord0);
    vec4 color1 = texture(u_texNew, v_texCoord0);

    color0.g -= ALPHA_DECREASE;

    if (color0.r * color0.g < color1.r){
        fragColor = color1;
    } else {
        fragColor = color0;
    }
}