#version 300 es

precision mediump float;

uniform float u_finalAlpha;
uniform sampler2D u_tex0;
uniform float u_enableBlend;

in float v_blur;
in float v_size;
in float v_alpha;
in float v_discard;

out vec4 fragColor;

const float MIN_BLUR = 0.18;
const float MAX_BLUR = 0.35;
const float ALPHA = 0.65;

float map(float value, float oldMin, float oldMax, float newMin, float newMax) {
    return newMin + (newMax - newMin) * (value - oldMin) / (oldMax - oldMin);
}

void main() {
    if(v_discard > 0.0){
        discard;
    }

    float blurX = 0.7 * distance(gl_PointCoord.xy, vec2(0.5, 0.5));
    float blurY = MIN_BLUR + (MAX_BLUR - MIN_BLUR) * v_blur;

    float alpha = texture(u_tex0, vec2(blurX, blurY)).r;
    if(u_enableBlend > 0.5f){
        fragColor = vec4(alpha * v_alpha * ALPHA * u_finalAlpha, 1.0, 0.0, 0.0);
    } else {
        fragColor = vec4(vec3(1.0), alpha * v_alpha * ALPHA * u_finalAlpha);
    }
}