#version 300 es

precision highp float;

in vec3 a_position;
in float a_start;
in float a_size;
in float a_alpha;
in float a_random;

uniform float XTOFACE;
uniform float ZTOFACE;
uniform float TIME_SCALE;
uniform float VELOCITY;
uniform float SIZE_SCALE;

uniform float u_xToFace;
uniform float u_zToFace;
uniform float u_timeScale;
uniform float u_velocity;
uniform float u_sizeScale;

uniform float u_enableBlend;
uniform float u_time;
uniform mat4 u_projViewTrans;
uniform mat4 u_viewTrans;
uniform float u_farClip;
uniform float u_pointSizeScale;

const float GRAVITY = 0.04;
const float FOCAL_WIDTH = 1.4;
const float FOCAL_DIS = 1.0;
const float SIZE = 280.0; // 800->280(800*0.35)

float map(float value, float oldMin, float oldMax, float newMin, float newMax) {
    return newMin + (newMax - newMin) * (value - oldMin) / (oldMax - oldMin);
}

float getBlurFactor(float depth) {
    return smoothstep(0.0, FOCAL_WIDTH, abs(FOCAL_DIS - (depth * u_farClip)));
}


out float v_blur;
out float v_size;
out float v_alpha;
out float v_discard;

const float PERIOD = 10.0;

void main() {
    float time = u_time - a_start;
    v_alpha = a_alpha * min(time, 1.0);
    v_size = a_size;

    time *= u_timeScale;
    float temp = time;
    vec3 newPos = a_position;

    float dy = u_velocity * time + 0.5 * GRAVITY * time * time;
    newPos.y -= dy;


    newPos.z += pow(temp / 3.0, 3.0) * u_zToFace;
    newPos.x -= pow(temp / 3.0, 3.0) * u_xToFace;

    vec3 positionVS = (u_viewTrans * vec4(newPos, 1.0)).xyz;
    float depth = -positionVS.z / u_farClip;
    v_blur = getBlurFactor(depth);

    float depthinv = 1.0 - depth;
    gl_PointSize = a_size * depthinv * depthinv * depthinv * SIZE * 0.5 * u_pointSizeScale;
    gl_Position = u_projViewTrans * vec4( newPos, 1.0 );

    v_discard = -1.0;
    float screenY = gl_Position.y/gl_Position.w;
    if(screenY < -0.18){
        v_discard = 1.0;
    }
    else if(screenY < 0.15){
        v_alpha *= (1.0 + (screenY - 0.15) * 3.0);
    }
}