#version 300 es

precision highp float;

uniform float u_time;
uniform float u_aspect;
uniform sampler2D u_cloud;

in highp vec2 v_texCoord0;

out vec4 fragColor;

void main() {
    vec2 st = vec2(v_texCoord0.x, -v_texCoord0.y);
    st.x *= u_aspect;
    st.x *= 0.25;

    vec2 st0 = st;
    st0.x -= u_time * 0.3;
    float alpha0 = texture(u_cloud, st0).r;

    vec2 st1 = st;
    st1 *= 0.8;
    st1.x -= u_time * 0.36;
    float alpha1 = texture(u_cloud, st1).g;

    vec2 st2 = st;
    st2 *= 0.6;
    st2.x -= u_time * 0.52;
    float alpha2 = texture(u_cloud, st2).b;

    float alpha = alpha1 + (1.0 - alpha1) * alpha0;
    alpha = alpha2 + (1.0 - alpha2) * alpha;
    alpha *= smoothstep(0.0, 0.5, v_texCoord0.y);

    fragColor = vec4(alpha, 0.0, 0.0, 1.0);
}