#version 300 es

precision mediump float;

in float v_alpha;
in float v_x;
uniform float u_finalAlpha;
out vec4 fragColor;

const float BORDER = 0.8;
const float ONE = 1.0;

void main()	{
    float alpha = v_alpha;

    if(v_x < -BORDER){
        alpha *= smoothstep(-ONE, -BORDER, v_x);
    }else if(v_x > BORDER){
        alpha *= smoothstep(ONE, BORDER, v_x);
    }

    fragColor = vec4(vec3(ONE), alpha);
    fragColor.a *= u_finalAlpha;
}