#version 300 es

in vec4 a_position;
in vec2 a_texCoord0;
in float a_size;
in float a_alpha;
in float a_start;
in float a_interval;

uniform mat4 u_projViewTrans;
uniform mat4 u_worldTrans;
uniform float u_time;
uniform float u_dpiScale;

out float v_alpha;

// 星星闪烁算法
float fx(float x){
//    2.8*pow((x-0.5), 2)+0.3;
    float y = clamp(x, 0.0, 1.0);
    y -= 0.5;
    y *= y;
    y *= 4.0;
    return y;
}

void main() {
    float time = mod(u_time - a_start, a_interval);
    v_alpha = a_alpha * fx(time);
    gl_Position = u_projViewTrans * u_worldTrans * a_position;
    gl_PointSize = a_size * u_dpiScale;
}