#version 300 es

precision highp float;
uniform vec2 u_resolution;
uniform sampler2D CC_Texture0;
out vec4 fragColor;
void main()
{
    vec2 uv = vec2(gl_FragCoord.xy / (u_resolution.xy / 2.0));
    vec2 halfpixel = 0.5 / (u_resolution.xy / 2.0);
    float offset = 9.0;

    vec4 sum = texture(CC_Texture0, uv) * 4.0;
    sum += texture(CC_Texture0, uv - halfpixel.xy * offset);
    sum += texture(CC_Texture0, uv + halfpixel.xy * offset);
    sum += texture(CC_Texture0, uv + vec2(halfpixel.x, -halfpixel.y) * offset);
    sum += texture(CC_Texture0, uv - vec2(halfpixel.x, -halfpixel.y) * offset);

    fragColor = sum / 8.0;
}