#version 300 es

precision lowp float;

uniform sampler2D u_texFlash;
uniform vec2 u_resolution;
uniform float u_flashTexAspect;

uniform float u_flashStrength;
uniform int u_flashIndex;
uniform float u_alpha;

in highp vec2 v_texCoord0;

out vec4 fragColor;

float blendAdd(float base, float blend) {
    return min(base+blend, 1.0);
}

vec3 blendAdd(vec3 base, vec3 blend) {
    return min(base+blend, vec3(1.0));
}

vec3 blendAdd(vec3 base, vec3 blend, float opacity) {
    return (blendAdd(base, blend) * opacity + base * (1.0 - opacity));
}

void main() {
    // flash
    float flashAlpha;

    if (v_texCoord0.y*u_flashTexAspect>1.0){
        discard;
    }

    highp vec2 flashTexCoord = vec2(v_texCoord0.x, v_texCoord0.y * u_flashTexAspect);
    if (u_flashIndex == 0){
        flashAlpha = texture(u_texFlash, flashTexCoord).r;
    } else if (u_flashIndex == 1){
        flashAlpha = texture(u_texFlash, flashTexCoord).g;
    } else {
        flashAlpha = texture(u_texFlash, flashTexCoord).b;
    }

    if (flashAlpha <= 0.02){
        discard;
    }

    flashAlpha *= u_flashStrength;

    vec3 finalColor = blendAdd(vec3(0.0), vec3(flashAlpha), flashAlpha);

    fragColor = vec4(finalColor, u_alpha);
}