#version 300 es

precision highp float;

uniform sampler2D u_texLight;
uniform sampler2D u_texFlash;

uniform vec2 u_resolution;
uniform float u_lightTexAspect;
uniform float u_flashTexAspect;

uniform float u_lightStrength;
uniform float u_flashStrength;
uniform int u_flashIndex;
uniform float u_alpha;


in vec2 v_texCoord0;

out vec4 fragColor;

float blendAdd(float base, float blend) {
    return min(base+blend, 1.0);
}

vec3 blendAdd(vec3 base, vec3 blend) {
    return min(base+blend, vec3(1.0));
}

vec3 blendAdd(vec3 base, vec3 blend, float opacity) {
    return (blendAdd(base, blend) * opacity + base * (1.0 - opacity));
}

void main() {
    // flash
    float flashAlpha;

    if (v_texCoord0.y*u_flashTexAspect>1.0){
        discard;
    }

    vec2 flashTexCoord = vec2(v_texCoord0.x, v_texCoord0.y * u_flashTexAspect);
    if (u_flashIndex == 0){
        flashAlpha = texture(u_texFlash, flashTexCoord).r;
    } else if (u_flashIndex == 1){
        flashAlpha = texture(u_texFlash, flashTexCoord).g;
    } else {
        flashAlpha = texture(u_texFlash, flashTexCoord).b;
    }

    if (flashAlpha <= 0.02){
        discard;
    }

    flashAlpha *= u_flashStrength;

    // light
    // 0~1, 1~1, 1~0
    vec2 lightTexCoord = vec2(v_texCoord0.x, v_texCoord0.y * u_lightTexAspect);
    vec3 lightColor = texture(u_texLight, lightTexCoord).rgb * u_lightStrength;//uStrength

    vec3 finalColor = blendAdd(vec3(lightColor), vec3(flashAlpha), flashAlpha);

    fragColor = vec4(finalColor, u_alpha);
}