function BLEConfig() {

    this.Create = function () {
        var param = {
            "REQ": "Create"
        };
        return jsonLocalCall('BLEConfig.Create', param);
    }

    this.GetConfig = function (tid) {
        var utcsec = Math.floor(new Date().getTime()/1000);
        var param = {
            "REQ": "GetConfig",
            "Tokenid":tid,
            "Date":utcsec
        };

        return jsonLocalCall('BLEConfig.GetConfig', param);
    }

    this.TTS = function (data) {
        var param = {
            "REQ": "TTS",
            "Data":{"REQ":"BLETTS","Data":BASE64.encode(data)}
        };
       // console.log(JSON.stringify(param));
        return jsonLocalCall('BLEConfig.TTS', param);
    }

    this.ScanEnable = function (enable) {
        var param = {
            "REQ": "ScanEnable",
            "Enable":enable
        };
        return jsonLocalCall('BLEConfig.ScanEnable', param);
    }

    this.GetBDName = function () {
        var param = {
            "REQ": "GetBDName"
        };
        return jsonLocalCall('BLEConfig.GetBDName', param);
    }

    this.Destroy = function () {
        var param = {
            "REQ": "Destroy"
        };
        return jsonLocalCall('BLEConfig.Destroy', param);
        //return jsonLocalCall('BLEConfig.Destroy', param);
    }



    this.Connect = function (enable,name) {
        var param = {
            "REQ": "Connect",
            "Name": name,
            "Connect": enable
        };
        return jsonLocalCall('BLEConfig.Connect', param);
    }

    this.GetResult = function (tid) {
        var gecfg={
            "REQ":"GetResult",
            "Tokenid":tid
        };
        this.TTS(JSON.stringify(gecfg));
    }

    this.BindDeviceV24G = function (name,tokenid) {

        var member = localApi.Evn.Sheet.Account.Member;
        var usrpwd = localApi.Evn.Sheet.Account.UsrPwd;

        console.log(JSON.stringify(param));

        var tmoffset = GetTimeZoneOffset();
        name = "base64"+BASE64.encode(name);
        var param = {
            "REQ": "BindDevice",
            "Tokenid":tokenid,
            "Net": {
                "TMOffset": tmoffset,
                "NetCard":"Mobile-4G"
            },        
            "Bind": {
                "AppKey": APP_KEY,
                "CustomerCode": APP_CustomerCode,
                "Member": member,
                "UsrPwd": usrpwd,
                "Name": name,
                "Url": "121.199.13.70",
                "Port": 50101,                
            }
        };        
        return this.TTS(JSON.stringify(param));
    }


    this.BindDevice = function (name, ssid, psk, bssid,cards,tokenid) {
        var member = localApi.Evn.Sheet.Account.Member;
        var usrpwd = localApi.Evn.Sheet.Account.UsrPwd;

        var tmoffset = GetTimeZoneOffset();
        name = "base64"+BASE64.encode(name);
        var param = {
            "REQ": "BindDevice",
            "Net": {
                "TMOffset": tmoffset,
                "NetCard":cards
            },
            "Member": [
                {
                    "Member": member,
                    "Permission": ["admin"],
                }
            ],
            "Bind": {
                "AppKey": APP_KEY,
                "CustomerCode": APP_CustomerCode,
                "Member": member,
                "UsrPwd": usrpwd,
                "Name": name,
                "Url": "121.199.13.70",
                "Port": 50101,
                "Tokenid":tokenid
            }
        };
        if( ssid != null ){

            console.log(JSON.stringify(param));
            param.Net.Wifi = {};
            param.Net.Wifi.ssid = ssid;
            param.Net.Wifi.psk = psk;
            param.Net.Wifi.bssid = bssid;
            param.Net.Wifi.dhcp = 1;
        }

        console.log(JSON.stringify(param));
        return this.TTS(JSON.stringify(param));
    }


    //bindbywifi connect
    this.BindByAppWifiTryConnect = function (ap,ssid,psk,bssid) {
        var data = {
            "REQ": "WifiTryConnect",
            "ssid": ssid,
            "bssid":bssid,
            "murl":"exaudio_86.audiocam.net",
            "mode":ap
        };
        if( psk )
            data["psk"] = psk;
        return this.TTS(JSON.stringify(data));
    }

    this.BindByAppBindDevice = function (member,duid,tid,tmoffset) {
        var utcsec = Math.floor(new Date().getTime()/1000);
        var data = {
            "REQ": "BindDeviceByApp",
            "Admin":{
                "DUID":duid,
                "Member":member,
            },
            "Bind":{
                "Date":utcsec,
                "TMOffset":tmoffset,
                "Tokenid":tid
            }
        };
        return this.TTS(JSON.stringify(data));
    }
}