

const PUSH_CODE_ARAM_PIR 	= 0x70000000;
const PUSH_CODE_ARAM_MOVE 	= 0x70000001;
const PUSH_CODE_USER_PUSHBELL = 0x70000002;


var localApi = new LocalApi();

function LocalApi() {

    this.Evn = {
        "ExternPath": "",
        "AppPath": "",
        "SaveJsonPath": "",
        "DBasePathName": "",
        "JsonAccountPathName": "",
        "PbAccountPathName": "",
        "Sheet": {}
    };


    this.Load = function() {
        var rlt = this.GetPath('Local.GetPath', {});
        if ( rlt && (rlt.Errno == 0) ) {
            this.Evn.ExternPath            = rlt.ExternPath + '/NetCamera_vscomm';
            this.Evn.PhotoPath             = this.Evn.ExternPath + '/Photo';
            this.Evn.AppPath               = rlt.AppPath;
            this.Evn.JsonAccountPathName   = rlt.AppPath +"/"+APP_KEY+"account.json";
            this.Evn.PbAccountPathName     = rlt.AppPath +"/"+APP_KEY+"account.pb";
            this.Evn.DBasePathName         = this.Evn.ExternPath +"/"+APP_KEY+"database.db";
        }
    }


    this.PushEnable = function(on){
        var param = {
            "PushEnable":"On"
        };
        if( on )
            param.PushEnable = "On";
        else
            param.PushEnable = "Off";
        return jsonLocalCall('Local.PushEnable', param);
    }

    this.WebInjectionJS = function( jsfunc ,jstext ){
        var param = {
            "JSFunc":jsfunc,
            "JSText":jstext
        };
        return jsonLocalCall('Local.WebInjectionJS', param);
    }

    this.JumpToTencentMM = function(){
        var param = {
        };
        return jsonLocalCall('Local.JumpToTencentMM', param);
    }

    this.HttpGet = function(url,id,callback){
        var param = {
            "URL":url,
            "ID":id,
            "CallBack":callback
        };
        return jsonLocalCall('Local.HttpGet', param);
    }

    this.GetLocalLanguage = function(){
        var param = {};
        return jsonLocalCall('Local.GetLocalLanguage', param);
    }

    this.UpdatePushMsg = function(date){
        var param = {
            "Date":date
        };
        return jsonLocalCall('Local.UpdatePushMsg', param);
    }
    this.DeletePushMsg = function(id){
        var param = {
            "ID":id
        };
        return jsonLocalCall('Local.DeletePushMsg', param);
    }

    this.AppExit = function () {
        var param = {
        };
        return jsonLocalCall('Local.AppExit', param);
    }

    this.ReadPushMsg = function(cid){
        var param = {
            "CID":cid
        };
        return jsonLocalCall('Local.ReadPushMsg', param);
    }

    this.GetPath = function() {
        var param = {};
        var rlt = jsonLocalCall('Local.GetPath', param);
        return rlt;
    }

    this.GetLocalNetInfo = function(){
        var param = {
        };
        return jsonLocalCall('Local.GetLocalNetInfo', param);
    }

    this.MkPath = function(path) {
        var param = {
            "Path": path
        };
        return jsonLocalCall('Local.MkPath', param);
    }

    this.GlobalValueRead = function(key,json) {
        var param = {
            "Key": key,
            "Value": json
        };
        return jsonLocalCall('Local.GlobalValueRead', param);
    }

    this.GlobalValueWrite = function(key,json) {
        var param = {
            "Key": key,
            "Value": json
        };
        return jsonLocalCall('Local.GlobalValueWrite', param);
    }

    this.GetVirtualKeyHeight = function() {
        var param = {
        };
        return jsonLocalCall('Local.GetVirtualKeyHeight', param);
    }




    this.CheckFile = function(path) {
        var param = {
            "PathName": path,
        };
        return jsonLocalCall('Local.CheckFile', param);
    }

    this.ValueWrite = function(key,value) {
        var param = {
            "Key":key,
            "Value": value+"",
        };
        return jsonLocalCall('Local.ValueWrite', param);
    }

    this.ValueRead = function(key) {
        var param = {
            "Key":key
        };
        return jsonLocalCall('Local.ValueRead', param);
    }

    this.SetPushEnable = function (cid,enable) {
        var param = {
            "CID":cid,
            "Enable":enable
        };
        return jsonLocalCall('Local.SetPushEnable', param);
    }


    this.JumpToIEBrowser = function (url) {
        var param = {
            "URL":url
        };
        return jsonLocalCall('Local.JumpToIEBrowser', param);
    }

    this.GoPermissionSet = function () {
        var param = {
            "Key":""
        };
        return jsonLocalCall('Local.GoPermissionSet', param);
    }

    this.GetPermission = function (permission) {
        var param = {
            "PermissionName": permission
        };
        return jsonLocalCall('Local.GetPermission', param);
    }

    this.MarkLogined = function (account,pwd) {
        localApi.ValueWrite("UsrAccount",account);
        localApi.ValueWrite("UsrPwd",pwd);
        localApi.ValueWrite("UserLoginStatus","Success");

    }
    this.ClearRegisterMode = function () {
        localApi.ValueWrite("RegMode","idle");
    }
    this.MarkRegisterMode = function (mode,account,pwd) {
        localApi.ValueWrite("RegMode",mode);
        localApi.ValueWrite("UsrAccount",account);
        localApi.ValueWrite("UsrPwd",pwd);
        localApi.ValueWrite("RegCodeDate",""+Math.trunc(new Date().getTime()/1000));
    }

    this.ClearUsrPwd = function () {
        localApi.ValueWrite("UsrPwd","");
        localApi.ValueWrite("UserLoginStatus","Exit");
    }



    this.GetRegisterMode = function () {
        try {
            var regmode = localApi.ValueRead("RegMode").Value;
            if( !regmode )return "idle";
            if( regmode == "idle" )return "idle";

            var rlt = localApi.ValueRead("RegCodeDate");
            if ( rlt.Value ) {
                var olddate = parseInt(rlt.Value) * 1000;
                var date = new Date().getTime();
                if(  date >= olddate   ){
                    if( ( date - olddate ) < 5*60*1000 ){
                        return regmode;
                    }
                }
            }
        }catch (e) {
        }
        return "idle";
    }

    this.CheckPermission = function(cmd) {

        var param = {
           "Permission": cmd
        };

        jsonLocalCall('Local.CheckPermission', param);
        return true;
    }

}


