/**
 RealVideo.AudioEnable
 RealVideo.VideoEnable
 RealVideo.Create
 RealVideo.Destroy
 VLinkVideoDraw.Create

 **/


function MediasPlay(cid) {
    this.connected = 0;
    this.cid = cid;
    this.drawObj = null;
    this.videoView = new VLinkVideoDraw(this.cid,"VlinkAudioPlay");
    this.Play = function (date) {
        var param = {
            "CID": this.cid,
            "Date": date,
        };
        return jsonCall('MediasPlay.Play', param);
    }
    this.Seek = function (date) {
        var param = {
            "CID": this.cid,
            "Date": date,
        };
        return jsonCall('MediasPlay.Seek', param);
    }


    this.Pause = function () {
        var param = {
            "CID": this.cid,
        };
        return jsonCall('MediasPlay.Pause', param);
    }

    this.Snap = function (fileName) {
        var param = {
            "CID": this.cid,
            "PathName":fileName
        };
        return jsonCall('MediasPlay.Snap', param);
    }

    this.Reset = function () {
        var param = {
            "CID": this.cid,
        };
        return jsonCall('MediasPlay.Reset', param);
    }
    this.SpeakEnable = function (enable) {
        var param = {
            "CID": this.cid,
            "Speak": enable
        };
        this.videoView.SpeakEnable(enable);
        return jsonCall('MediasPlay.AudioEnable', param);
    }


    this.DestroyPrepare = function () {
        this.videoView.Destroy();
    }
    this.Destroy = function () {
        var param = {
            "CID": this.cid
        };
        return jsonAsyncCall('MediasPlay.Destroy', param);
    }
    this.Create = function (x, y, w, h) {
        var param = {
            "CID": this.cid,
            "CPUs": 2
        };
        var rlt = jsonCall('MediasPlay.Create', param);
        if (rlt.Errno == 0) {
            this.drawObj = this.videoView.Create(this.cid, rlt.Param.Obj, x, y, w, h);
        }

    }

    this.SetScale = function (x, y, scale) {
        return this.videoView.SetScale(x, y,scale);
    }


    this.SetFrameSpace = function (x, y, w, h, show) {
        return this.videoView.SetFrameSpace(x, y, w, h, show);
    }

    this.SetFrame = function (x, y, w, h, landscape) {
        return this.videoView.SetFrame(x, y, w, h, landscape);
    }

    this.ShowEnable = function (enable) {
        return this.videoView.SetVisibility(enable);
    }

    this.RecordEnable = function (pathname,enable) {
        var param = {
            "CID": this.cid,
            "PathName": pathname,
            "Enable":enable
        };
        return jsonCall('MediasPlay.RecordEnable', param);
    }
}
/*
请求格式
    REQ:command
应答格式
    RES:command

请求注册

{
    "REQ":"Register"
    "ID":"设备ID"
    "DevType":设备类型
}





 */
