





function PPEXClients(onEvent) {

    this.onEvent = function ( json ) {
        if( onEvent != null ) {
            onEvent(json);
        }
    }



    this.P2PConnect  =function (cid) {
        var param = {
            "CID": cid,            
            "Param":{},
        };
        return jsonCall('PPEXClients.P2PConnect', param);
    }

    this.P2PDisconnect  =function (cid) {
        var param = {
            "CID": cid,            
            "Param":{},
        };
        return jsonCall('PPEXClients.P2PDisconnect', param);
    }

    this.RemoveClient = function (cid) {
        var param = {
            "CID": cid,
        };
        return jsonCall('PPEXClients.RemoveClient', param);
    }

    this.AddClient = function ( cid, pwd, duid, member,cuuid,mrul,push ) {
        var param = {
            "CID": cid,
            "Param":{"DUID": duid,"Member": member,"CUID":cuuid,"murl":mrul},
            //"UUID": {"UUID": uuid, "Member": member,"CUUID":cuuid},}
            "Pwd": pwd,
            "PushEnable":push
        };
        return jsonCall('PPEXClients.AddClient', param);
    }

    this.GetSharedConfig = function (cid,member) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetSharedConfig",   
                "Member":member
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.SetSharedConfig = function (cid,member,duid,pmt) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetSharedConfig",
                "Member":member,
                "DUID":duid,
                "PMT":pmt
            }
        }
        
        return jsonCall('PPEXClients.SendJson', param);
    }
    
    this.SetPrivateMode = function (cid,on) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetPrivateMode",
                "PrivateOn":on
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }


    this.DeleteSharedConfig = function (cid,member) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "DeleteSharedConfig",
                "Member":member
            }
        }
    
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.SyncSharedConfig = function (cid,members) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SyncSharedConfig",
                "Members":members
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.GetDiskInfo = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDiskInfo"
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.GetFeature = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetFeature"
            }
        }
        jsonCall('PPEXClients.SendJson', param);
    }

    this.DiskFormat = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "DiskFormat"
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.Reboot = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "Reboot"
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }


    this.GetRecordMode = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetRecordMode"
            }
        }
        jsonCall('PPEXClients.SendJson', param);

    }


    this.SetRecordMode = function (cid,DeNoise,Mode,AutoDB,ManualDB) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetRecordMode",
                "DeNoise":DeNoise,
                "Mode":Mode,
                "AutoDB": parseFloat(AutoDB.toFixed(1)),
                "ManualDB": parseFloat(ManualDB.toFixed(1))
            }
        }

        jsonCall('PPEXClients.SendJson', param);
    }

    this.RealAudioEnable = function(cid,enable) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "RealAudio",
                "Enable":enable
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.UnBindDevice = function(cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "UnBindDevice"
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.GetFiles = function(cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetFiles",
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

    this.FtpOpen = function(cid,name) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "FtpOpen",
                "Name": name
            }
        }
        return jsonCall('PPEXClients.SendJson', param);
    }

   
    this.GetLinkStatus = function (cid) {
        var param = {
            "CID": cid,
        };
        return jsonCall('PPEXClients.GetLinkStatus', param);
    }

    this.FirmwareUpgrade = function (cid,uid,ip,port,filename) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "FirmwareUpgrade",
                "Param": {
                    "UID":uid,
                    "IP":ip,
                    "Port":port,
                    "FileName":filename,
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }



}




