/**
 RealVideo.AudioEnable
 RealVideo.VideoEnable
 RealVideo.Create
 RealVideo.Destroy
 VLinkVideoDraw.Create

 **/
function randomInterString(length ) {
    var chars="123456789";
    var result = '';
    for ( var i = length; i > 0; --i )
        result += chars[Math.floor(Math.random() * chars.length)];
    return result;
}


function RealVideo(cid) {
    this.connected = 0;
    this.cid = cid;
    this.drawObj = null;
    this.videoView = new VLinkVideoDraw(this.cid,"VlinkVoip");
    this.VideoEnable = function (ch, enable) {
        var param = {
            "CID": this.cid,
            "Channel": ch,
            "Enable": enable,
        };
        return jsonCall('RealVideo.VideoEnable', param);
    }


    this.Snap = function (pathname) {
        var param = {
            "CID": this.cid,
            "PathName": pathname
        };
        return jsonCall('RealVideo.Snap', param);
    }

    this.RecordEnable = function (pathname,enable) {
        var param = {
            "CID": this.cid,
            "PathName": pathname,
            "Enable":enable
        };
        return jsonCall('RealVideo.RecordEnable', param);
    }

    this.SpeakEnable = function (enable) {
        var param = {
            "CID": this.cid,
            "Speak": enable
        };
        this.videoView.SpeakEnable(enable);
        return jsonCall('RealVideo.AudioEnable', param);
    }

    this.MicrophoneEnable = function (enable) {
        var param = {
            "CID": this.cid,
            "Microphone": enable
        };
        this.videoView.MicrophoneEnable(enable);
        return jsonCall('RealVideo.AudioEnable', param);
    }
    //VLinkVideoDraw.AudioEnable



    this.MotorEnable = function (name, steps) {
        var param = {
            "CID": this.cid,
            "Name": name,
            "Steps": steps,
            "Speed": 500
        };
        return jsonCall('RealVideo.MotorEnable', param);
    }

    this.Destroy = function () {

        this.videoView.Destroy();
        var param = {
            "CID": this.cid
        };
        return jsonAsyncCall('RealVideo.Destroy', param);
    }
    this.Create = function (x, y, w, h,scalex) {
        var param = {
            "CID": this.cid,
            "CPUs": 2
        };
        var rlt = jsonCall('RealVideo.Create', param);
        if ( rlt.Errno == 0 ) {
            this.drawObj = this.videoView.Create(this.cid, rlt.Param.Obj, x, y, w, h,scalex);
        }
        return rlt;
    }

    //SetVideoViewSpace

    this.SetFrameSpace = function (x, y, w, h, show) {
        return this.videoView.SetFrameSpace(x, y, w, h, show);
    }

    this.SetFrame = function (x, y, w, h, landscape) {
        return this.videoView.SetFrame(x, y, w, h, landscape);
    }
    this.SetScale = function (x, y, scale) {
        return this.videoView.SetScale(x, y,scale);
    }
    this.SetFullScreen= function (enable) {
        return this.videoView.SetFullScreen(enable);
    }


    this.ShowEnable = function (enable) {
        return this.videoView.SetVisibility(enable);
    }
}

function VLinkVideoDraw(cid,voip) {
    this.cid = cid;
    this.Obj = null;
    this.selfObj = null;
    this.Create = function (cid, obj, x, y, w, h,scalex) {
        this.selfObj = randomInterString(16);
        var param = {
            "CID": cid,
            "Obj": obj,
            "x": x, "y": y, "w": w, "h": h,
            "VlinkVoip": voip,
            "ObjSelf": this.selfObj,
            "ScaleX":scalex
        };
        jsonLocalCall('VLinkVideoDraw.Create', param);
        return this.selfObj;
    }

    this.SetVisibility = function (enable) {
        var param = {
            "CID": this.cid,
            "Enable": enable,
            "ObjSelf": this.selfObj
        };
        return jsonLocalCall('VLinkVideoDraw.SetVisibility', param);
    }

    this.SetFullScreen = function (enable) {
        var param = {
            "CID": this.cid,
            "Enable": enable,
            "ObjSelf": this.selfObj
        };
        return jsonLocalCall('VLinkVideoDraw.SetFullScreen', param);
    }

    this.Destroy = function () {
        var param = {
            "CID": this.cid,
            "ObjSelf": this.selfObj
        };
        return jsonLocalCall('VLinkVideoDraw.Destroy', param);
    }


    this.SetScale = function (x,y,scale ) {
        var param = {
            "CID": this.cid,
            "ObjSelf": this.selfObj,
            "CenterX": x,
            "CenterY": y,
            "Scale": scale
        };
        return jsonLocalCall('VLinkVideoDraw.SetScale', param);
    }

    this.SetFrameSpace = function (x, y, w, h, show) {
        var param = {
            "CID": this.cid,
            "ObjSelf": this.selfObj,
            "x": x, "y": y, "w": w, "h": h,
            "show":show
        };

        return jsonLocalCall('VLinkVideoDraw.SetFrameSpace', param);
    }


    this.SetFrame = function (x, y, w, h, landscape) {
        var param = {
            "CID": this.cid,
            "ObjSelf": this.selfObj,
            "x": x, "y": y, "w": w, "h": h
        };
        if (landscape != null) {
            param.landscape = landscape;
        }
        return jsonLocalCall('VLinkVideoDraw.SetFrame', param);
    }

    this.SpeakEnable = function (enable) {
        var param = {
            "CID": this.cid,
            "Speak": enable,
            "ObjSelf": this.selfObj,
        };
        return jsonLocalCall('VLinkVideoDraw.AudioEnable', param);
    }

    this.MicrophoneEnable = function (enable) {
        var param = {
            "CID": this.cid,
            "Microphone": enable,
            "ObjSelf": this.selfObj,
        };
        return jsonLocalCall('VLinkVideoDraw.AudioEnable', param);
    }
}






