

var clientGroup = new ClientGroup();

function ClientGroup() {

    this.AddClient = function ( cid, pwd, duid, member,cuuid,push ) {
        var param = {
            "CID": cid,
            "Param":{"DUID": duid,"Member": member,"CUID":cuuid},
            //"UUID": {"UUID": uuid, "Member": member,"CUUID":cuuid},}
            "Pwd": pwd,
            "PushEnable":push
        };
        return jsonCall('ClientGroup.AddClient', param);
    }

    this.CHDataSend = function(cid,ch,data) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "CHData",
                "Param":{
                    "CH":ch,
                    "Data":data
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.LightTurnGetStatus =function (cid,sts,seconds ) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "TurnLight",
                "Param":
                    {
                        "Type":"WhiteLight",
                        "Seconds":seconds,
                        "Status":sts
                    }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.RemoveClient = function (cid) {
        var param = {
            "CID": cid,
        };
        return jsonCall('ClientGroup.RemoveClient', param);
    }

    this.GetLinkStatus = function (cid) {
        var param = {
            "CID": cid,
        };
        return jsonCall('ClientGroup.GetLinkStatus', param);
    }


    this.ConnectEnable = function (cid, enable) {
        var param = {
            "CID": cid,
            "Enable": enable,
        }
        return jsonCall('ClientGroup.ConnectEnable', param);
    }


    this.GetClients = function () {
        var param = {};
        return jsonCall('ClientGroup.GetClients', param);
    }




    this.RecordAlarmSound = function (cid,enable) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "RecordAlarmSound",
                "Param":{
                    "Enable":enable
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetAlarmSoundList = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetAlarmSoundList"
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SetAlarmSoundList = function (cid,sound) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetAlarmSoundList",
                "Param":{
                    "Sound":sound
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }


    this.GetAlarmMessage = function (cid,date,end_date,tid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetAlarmMessage",
                "TID" : tid,
                "EndDate":end_date,
                "StartDate":date
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }



    this.GetDiskInfo = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDiskInfo"
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetNetInfo = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetNetInfo"
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }


    this.UnBindDevice = function(cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "UnBindDevice"
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.UartCommWriteJson = function (cid,data) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "UartComm",
                "Data":data
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }


    this.SetLocalNetInfo = function (cid,ip,mask) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetLocalNetInfo",
                "IP":ip,
                "Mask":mask
            }
        }
        return jsonCall('ClientGroup.SetLocalNetInfo', param);
    }

    this.SetPushEnable = function (cid,enable) {
        var param = {
            "CID":cid,
            "PushEnable":enable
        };
        return jsonCall('ClientGroup.SetPushEnable', param);
    }



    this.SetRecordDate = function (cid,date) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param":[
                    {
                        "SubSet":"Record",
                        "Value":{
                            "RecordDate":date
                        }
                    }
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }


    this.GetPermission = function (cid,member) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param": [
                    {"SubSet":"Member","Value":{"Member":member,"PMIT":0}},
                ]
            }
        }

        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetPrivate = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param": [
                    {"SubSet":"Private","Value":{"PrivateMode":0}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SetPrivate = function (cid, enable,date) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param": [
                    {"SubSet":"Private","Value":{"PrivateMode":enable}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetPrivateDate = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param": [
                    {"SubSet":"Private","Value":{"PrivateDate":0}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SetPrivateDate = function (cid,date) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param": [
                    {"SubSet":"Private","Value":{"PrivateDate":date}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }


    this.GetAlarmDate = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param":[
                    {"SubSet":"Alarm","Value":{"AlarmDate":0}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }
    this.SetAlarmDate = function (cid,date) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param":[
                    {"SubSet":"Alarm","Value":{"AlarmDate":date}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SetRecordMode = function (cid,mode) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param":[
                    {
                        "SubSet":"Record",
                        "Value":{
                            "RecordMode":mode
                        }
                    }
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetRecordMode = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param":[
                    {"SubSet":"Record","Value":{"RecordMode":0,"RecordDate":0}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetSetingInfo = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param":[
                    {"SubSet":"IMG","Value":{"ObjectLock":0}},
                    {"SubSet":"IMG","Value":{"VideoRotate":0}},
                    {"SubSet":"Alarm","Value":{"MotionDect":0,"AlarmSound":0}},
                    {"SubSet":"Light","Value":{}}
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SetTriggerLight = function (cid,type) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param":[
                    {
                        "SubSet":"Light",
                        "Value":{
                            "TriggerLight":type
                        }
                    }
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }
    //ImageEffect


    this.SetAwaysDay = function (cid,value) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "AwaysDay",
                "Param":{
                    "Value":value
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetAwaysDay = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param": [
                    {"SubSet": "AwaysDay", "Value": {"Enable": 0}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SetAwaysDay = function (cid,enable) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param": [
                    {"SubSet": "AwaysDay", "Value": {"Enable": enable}},
                ]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }


    this.SetImageEffect = function (cid,value) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetImageEffect",
                "Param":{
                    "Value":value
                }
            }
        }
        //console.log("img_scenery_onclick:"+JSON.stringify(param));

        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetImageEffect = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetImageEffect",
                "Param":{
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.TurnLight = function (cid,onoff,seconds) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "TurnLight",
                "Param":{
                    "Type":"WhiteLight",
                    "Status":onoff,
                    "Seconds":seconds
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetCFG = function (cid,key) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetCFG",
                "Param":[key]
            }
        }

        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetDeviceDescriptor = function (cid,param1) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceDescriptor",
                "Param":[]
            }
        }
        param.Transmit["Param"].push(param1);
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetDeviceFeatureBak = function (cid,param1) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceFeature",
                "Param":[]
            }
        }
        param.Transmit["Param"].push(param1);
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetFeature = function (cid,param1) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetFeature",
                "Param":[]
            }
        }
        param.Transmit["Param"].push(param1);

        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetDeviceConfig = function (cid,param1) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param":[]
            }
        }
        param.Transmit["Param"].push(param1);

        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SetDeviceConfig = function (cid,param1) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param":[]
            }
        }
        param.Transmit["Param"].push(param1);
        return jsonCall('ClientGroup.SendJson', param);
    }
    //GetFeature
    this.GetFeature = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetFeature",
                "Param":[]
            }
        }

        return jsonCall('ClientGroup.SendJson', param);
    }



    this.GetPower = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetPower",
                "Param":[]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.GetDeviceInfo = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceInfo",
                "Param":[]
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.DiskFormat = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "DiskFormat"
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }


    this.GetShareDevicePMIT = function (cid,member) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param": [
                    {
                        "SubSet": "Member",
                        "Value":{"Member":member,"PMIT":0,"PermitDate":0},
                    },
                ]
            }
        }

        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SharedDevice = function (cid,member,duid,pmit,date) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param": [ {"SubSet": "Member","Value": {"Member": member}} ]
            }
        };
        if( duid != null )
            param.Transmit.Param[0]["Value"]["DUID"]        = duid;
        if( pmit != null )
            param.Transmit.Param[0]["Value"]["PMIT"]        = pmit;
        if( date != null )
            param.Transmit.Param[0]["Value"]["PermitDate"] = date;
        return jsonCall('ClientGroup.SendJson', param);

    }


    this.GetSharedDeviceMembers = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param": [ {"SubSet": "Members","Value":{}} ]
            }
        };
        return jsonCall('ClientGroup.SendJson', param);
    }

    /**
    this.GetSharedDeviceMembersDUID = function (cid,members) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "GetDeviceConfig",
                "Param":[]
            }
        };
        for(var i = 0;i<members.length;i++){
            param.Transmit.Param[i]["SubSet"] = "DUID";
            param.Transmit.Param[i]["Value"]["Member"] = members[i];
        }
        return jsonCall('ClientGroup.SendJson', param);
    }
    **/

    this.DeleteSharedDevice = function (cid,member) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SetDeviceConfig",
                "Param": [ {"SubSet": "MemberDelete","Value": {"Member": member}} ]
            }
        };
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.UploadVlog = function (cid) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "VLogUpload",
                "url": "120.24.35.176:8008/upload"
            }
        };
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.SyncSharedDevice = function (cid,members) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "SharedDevice",
                "Member": members,
            }
        };
        return jsonCall('ClientGroup.SendJson', param);
    }

    this.FirmwareUpgrade = function (cid,uid,ip,port,filename) {
        var param = {
            "CID": cid,
            "Transmit": {
                "REQ": "FirmwareUpgrade",
                "Param": {
                    "UID":uid,
                    "IP":ip,
                    "Port":port,
                    "FileName":filename,
                }
            }
        }
        return jsonCall('ClientGroup.SendJson', param);
    }



}




