extends %BASE%

const BATTLE_ROLE = preload("res://Scripts/Method/BattleRoleMth.gd")
const ROLE_SKILL = preload("res://Scripts/Method/RoleSkillMth.gd")

onready var BATTLE_ROLE_METHODS: BATTLE_ROLE = BATTLE_ROLE.new()
onready var ROLE_SKILL_METHODS: ROLE_SKILL = ROLE_SKILL.new()

onready var TimeLineNode = find_parent("Battle").get_node("GUI/Topbar/TimeLine")


# =======================
#       enemy 变量
# =======================

# AI 技能释放等待时间记录
var skillWaitTime = 0.0
# 是否处于技能释放阶段
var isSkilling = false

# 主动技能位移状态
var posIdxMoveActiveId = ""


var attackId = ""
var attackLevel = ""

var skillId = ""
var skillLevel = ""

# 对话内容 & 概率
onready var talkDataList = UTILS_METHODS.ENEMY_NORMAL_MESSAGE_TEMPLATE.duplicate(true)


# =======================
#        定制变量
# =======================

var privateDataTemplate = {}
var privateData = privateDataTemplate.duplicate(true)


# =======================
#       自定义方法
# =======================

# 处理攻击
func handle_attack():
    @@@修改为对应的攻击ID 如8001-01
	attackId = ""
	attackLevel = "1"


# 处理技能
# rolePosIdx 为 -1 则说明 指使对象为 self
func handle_role_skill(skId: String, skLevel: String, _rolePosIdx: int, skIsEnemy: bool):
    skillId = skId
	skillLevel = skLevel

	# 获取偏移值
	var offsetX = DataManager.OFFSET_BASE_POSX * find_parent("Battle").get_node("RoomContainer").currentPosOffset 

	if skillId == "":
        pass


# 处理主动技能位置变更结束
func handle_after_posi_changed():
	pass


# 处理被动位置变更结束
func handle_after_posi_passive_changed(_isMoved: bool):
	pass


# 处理死亡
func handle_enemy_died():
	# 是召唤物则不触发
	if get_parent().isMinion:
		return
	# 结果鉴定-如果enemy全部死亡，则胜利
	if BATTLE_ROLE_METHODS.check_role_all_died(find_parent("RoleContainer"), true):
		find_parent("Battle").get_node("RoomContainer").handle_fight_success()


# 战斗中Walk完成
func handle_to_be_walk():
	print("walk end")


# 处理被召唤完成
func handle_to_be_minion():
	print("minion end")


# 播放角色动画
func play_role_anim(animName: String):
	# 这里可以根据动画名做一些预处理
	$AnimationPlayer.play(animName)


# =======================
#        私有方法
# =======================




# =======================
#          Hook
# =======================

# 造成伤害回调
func handle_damage_spec(_hurtList: Array):
	pass



# =======================
#  定制 Hook ( 用于动画 )
# =======================





# =======================
#        执行技能
# =======================

func _handle_use_8901_11():
    pass


# =======================
#        系统事件
# =======================

func _process(_delta):
	if get_parent().isActionPlaying == "Died":
		return
    
    _handle_use_8901_11()


# =======================
#        绑定事件
# =======================

# == 战斗开始 hook ==
func role_fight_start_hook():
	pass


# == 昏迷 hook ==

# 昏迷开始
func role_sleep_start_hook():
	pass

# 昏迷结束
func role_sleep_end_hook():
	pass


# == 位移hook ==

# 角色位置变更开始
func role_pos_move_tween_before_hook(currentPosIdx: int, toPosIdx: int):
	# 播放fx特效
	var isToLeft = currentPosIdx < toPosIdx
	var fxPosX = get_parent().position.x
	find_parent("Battle").get_node("RoleFXContainer").play_fx_effect(
		"Small_Smoke", Vector2(fxPosX, 0), isToLeft
	)


# 位移开始
# moveType = goAttack | goSkill | backAttack | backSkill
func role_tween_before_go_hook(_moveType: String, _posX: float):
	# 播放fx特效
	var isToLeft = get_parent().position.x < _posX
	var fxPosX = get_parent().position.x
	find_parent("Battle").get_node("RoleFXContainer").play_fx_effect(
		"Small_Smoke", Vector2(fxPosX, 0), isToLeft
	)

# 攻击位移结束
func role_tween_go_attack_hook():
	pass

# 技能攻击位移结束
func role_tween_go_skill_hook():
	pass

# 攻击 完成位移
func role_tween_go_back_attack_hook():
	pass

# 技能 完成位移
func role_tween_go_back_skill_hook():
	isSkilling = false