extends %BASE%

const BATTLE_ROLE = preload("res://Scripts/Method/BattleRoleMth.gd")
const ROLE_SKILL = preload("res://Scripts/Method/RoleSkillMth.gd")

onready var BATTLE_ROLE_METHODS: BATTLE_ROLE = BATTLE_ROLE.new()
onready var ROLE_SKILL_METHODS: ROLE_SKILL = ROLE_SKILL.new()

# ========= 通用变量 =========

# 主动技能位移状态
var posIdxMoveActiveId = ""


var attackId = ""
var attackLevel = ""

var skillId = ""
var skillLevel = ""

# 对话内容 & 概率
onready var talkDataList = UTILS_METHODS.ROLE_NORMAL_MESSAGE_TEMPLATE.duplicate(true)


# ========= 定制变量 =========

var privateDataTemplate = {}
var privateData = privateDataTemplate.duplicate(true)


# ========= 通用方法 =========

# 处理攻击
func handle_attack(atkId, atkLevel):
	attackId = atkId
	attackLevel = atkLevel

	# 获取偏移值
	var offsetX = DataManager.OFFSET_BASE_POSX * find_parent("Battle").get_node("RoomContainer").currentPosOffset

	# === 技能解析 ===

	if attackId == "":
		pass


# 处理技能
# rolePosIdx 为 -1 则说明 为 click 事件
func handle_role_skill(skId: String, skLevel: String, rolePosIdx: int, skIsEnemy: bool):
	skillId = skId
	skillLevel = skLevel

	# 获取偏移值
	var offsetX = DataManager.OFFSET_BASE_POSX * find_parent("Battle").get_node("RoomContainer").currentPosOffset

	# === 技能解析 ===
	
	if skillId == "":
		pass


# 处理主动技能位置变更结束
func handle_after_posi_changed():
    @@@修改为对应的位移技能ID 如101-41
	if posIdxMoveActiveId == "-41":
		get_parent().skill_end()
		return
	else:
		return


# 处理被动位置变更结束
func handle_after_posi_passive_changed(_isMoved: bool):
	pass


# 处理死亡
func handle_enemy_died():
	print("【101】Died")


# 战斗中Walk完成
func handle_to_be_walk():
	print("walk end")


# 处理被召唤完成
func handle_to_be_minion():
	print("minion end")


# 播放角色动画
func play_role_anim(animName: String):
	# 这里可以根据动画名做一些预处理
	$AnimationPlayer.play(animName)


# ========= 私有方法 =========




# ========= Hook =========

# 造成伤害后回调
func handle_damage_spec(_hurtList: Array):
    pass


# ========= 单Role定制方法 =========



# ========= 绑定事件 =========

# == 战斗开始 hook ==
func role_fight_start_hook():
	pass


# == 昏迷 hook ==

# 昏迷开始
func role_sleep_start_hook():
	pass

# 昏迷结束
func role_sleep_end_hook():
	pass


# == 位移hook ==

# 角色位置变更开始
func role_pos_move_tween_before_hook(currentPosIdx: int, toPosIdx: int):
	# 播放fx特效
	var isToLeft = currentPosIdx > toPosIdx
	var fxPosX = get_parent().position.x
	find_parent("Battle").get_node("RoleFXContainer").play_fx_effect(
		"Small_Smoke", Vector2(fxPosX, 0), isToLeft
	)


# 位移开始
# moveType = goAttack | goSkill | backAttack | backSkill
func role_tween_before_go_hook(_moveType: String, _posX: float):
	# 播放fx特效
	var isToLeft = get_parent().position.x < _posX
	var fxPosX = get_parent().position.x
	find_parent("Battle").get_node("RoleFXContainer").play_fx_effect(
		"Small_Smoke", Vector2(fxPosX, 0), isToLeft
	)


# 攻击位移结束
func role_tween_go_attack_hook():
	pass

# 技能攻击位移结束
func role_tween_go_skill_hook():
	pass

# 攻击 完成位移
func role_tween_go_back_attack_hook():
	pass

# 技能 完成位移
func role_tween_go_back_skill_hook():
	pass

