package im.zego.zegoexpress.entity;

import android.app.Application;
import android.graphics.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.internal.*;
import java.nio.*;
import java.util.*;
import org.json.*;

/**
 * Mixer whiteboard object.
 *
 * Configure the mix whiteboard ID, aspect ratio and the layout.
 */
public class ZegoMixerWhiteboard {

    /** Whiteboard ID. */
    public long whiteboardID;

    /** Whiteboard aspect ratio(width), the default aspect ratio is 16:9. */
    public int horizontalRatio;

    /** Whiteboard aspect ratio(height), the default aspect ratio is 16:9. */
    public int verticalRatio;

    /** Whether the whiteboard will load dynamic PPT files or not, default value is false. */
    public boolean isPPTAnimation;

    /** Whiteboard layout. */
    public Rect layout;

    /** Whiteboard z-order. */
    public int zOrder;

    public ZegoMixerWhiteboard() {
        whiteboardID = 0;
        horizontalRatio = 16;
        verticalRatio = 9;
        isPPTAnimation = false;
        layout = new Rect();
        zOrder = 0;
    }
}
