﻿function setLanguage(string) {
    if (!string) {
        return;
    }
    string = string.split(',');
    var h1 = document.getElementsByTagName('h1');
    h1[0].innerHTML = '<span>' + string[0] + '</span>';
    h1[1].innerHTML = '<span>' + string[5] + '</span>';
    h1[2].innerHTML = '<span>' + string[7] + '</span>';
    var em = document.getElementsByTagName('em');
    em[0].innerHTML = string[1] + '<span></span>' + string[2];
    em[1].innerHTML = string[3] + '<span></span>' + string[4];
    document.getElementById('total').innerHTML = string[9];
    document.getElementById('month').innerHTML = string[6];
    var span = document.getElementsByTagName('span');
    span[span.length - 1].innerHTML = string[8];
}

function touchMotion() {
    var android = /android/i.test(navigator.userAgent);
    var ios = false;
    var ipad = /ipad/i.test(navigator.userAgent);
    var iphone = /iphone/i.test(navigator.userAgent);
    if (ipad || iphone) {
        ios = true;
    }
    var clickAction, actionStart, actionMove, actionEnd;
    if (android || ios) {
        actionStart = 'touchstart';
        actionMove = 'touchmove';
        actionEnd = 'touchend';
        clickAction = 'touchend';
    } else {
        actionStart = 'mousedown';
        actionMove = 'mousemove';
        actionEnd = 'mouseup';
        clickAction = 'click';
    }
    var action = document.getElementById('action');
    action.addEventListener(clickAction, function(e) {
        e.stopPropagation();
        e.preventDefault();
        var url;
        var target = e.target;
        var nodeName = target.nodeName.toLowerCase();
        if (nodeName == 'a' || nodeName == 'span') {
            target = target.parentNode;
        }
        switch (target.className) {
            case 'book':
                if (android) {
                    url = 'android';
                } else if (ios) {
                    url = 'ios';
                } else {
                    url = 'ms';
                }
                break;
            case 'set':
                if (android) {
                    url = 'android';
                } else if (ios) {
                    url = 'ios';
                } else {
                    url = 'ms';
                }
                break;
            case 'study':
                if (android) {
                    url = 'android';
                } else if (ios) {
                    url = 'ios';
                } else {
                    url = 'ms';
                }
                break;
            case 'browse':
                if (android) {
                    url = 'android';
                } else if (ios) {
                    url = 'ios';
                } else {
                    url = 'ms';
                }
                break;
        }
        window.location = 'cmd://'+url + '/' + target.className;
    }, false);
    if (!android && !ios) {
        document.addEventListener('selectstart', function(e) {
            e.preventDefault();
        }, false);
    }
    var charts = document.getElementById('charts'),
        controller = document.getElementById('controller'),
        controllers = controller.getElementsByTagName('a'),
        index = 0;
    var pageX, x, flag;
    var startPosition;
    charts.style.left = 0;
    charts.addEventListener(actionStart, function(e) {
        if (android || ios) {
            pageX = e.touches[0].pageX;
            x = null;
        } else {
            pageX = e.pageX;
        }
        startPosition = pageX;
    }, false);
    if (android || ios) {
        charts.addEventListener('touchmove', function(e) {
            e.preventDefault();
            x = e.touches[0].pageX - pageX;
        }, false);
    }
    charts.addEventListener(actionEnd, function(e) {
        if (!android && !ios) {
            x = e.pageX - pageX;
        }
        if (x > 0) {
            flag = 1;
            if (index == 0) {
                return;
            } else {
                index -= 1;
            }
        }
        if (x < 0) {
            flag = -1;
            if (index == 2) {
                return;
            } else {
                index += 1;
            }
        }
        var j = parseInt(charts.style.left);
        if ((flag == -1 && j == -200) || (flag == 1 && j == 0)) {
            return;
        }
        for (var i = 0; i < 100; i += 5) {
            (function(n) {
                setTimeout(function() {
                    j = parseInt(charts.style.left);
                    charts.style.left = j + 5 * flag + '%';
                }, (n / 10 + 1) * 2)
            }(i))
        }
        controller.getElementsByClassName('cur')[0].className = '';
        controllers[index].className = 'cur';
    }, false);
}

function setBookName(name) {
    if (name) {
        var bookName = document.getElementById('bookName');
        bookName.innerHTML = name;
    }
}

function pieChar(ratio, data) {
    var pie = document.getElementById('pie');
    if(pie){
        pie.parentNode.removeChild(pie);
    }
    var pieContainer = document.getElementById('pieContainer'), pieContent = pieContainer.innerHTML;
    pieContent = '<canvas id="pie"></canvas>'+pieContent;
    pieContainer.innerHTML = pieContent;
    if (ratio==undefined || !data) {
        return;
    }
    var fillColor;
    switch (document.body.className) {
        case 'en':
            fillColor = '#3ba8d7';
            break;
        case 'fr':
            fillColor = '#378dca';
            break;
        case 'de':
            fillColor = '#2cb26d';
            break;
        case 'es':
            fillColor = '#d33937';
            break;
    }
    var pieChar = document.getElementById('pie');
    var d = document.getElementById("wordData").getElementsByTagName("span");
    document.getElementById('total').getElementsByTagName('span')[0].innerHTML = data.total;
    d[0].innerHTML = data.master;
    d[1].innerHTML = data.learning;
    if (!pieChar) {
        alert('浏览器不支持canvas功能')
        return;
    }
    var lightColor = '#f1f1f3',
        lightRatio = 1 - ratio,
        context = pieChar.getContext('2d');
    var width = window.getComputedStyle(pieChar, null).height;
    var r = parseInt(width) / 2;
    r = parseInt(r);
    width = r * 2;

    pieChar.setAttribute('width', width);
    pieChar.setAttribute('height', width);
    pieChar.style.marginLeft = -1 * r + 'px';

    context.beginPath();
    context.fillStyle = fillColor;
    context.arc(r, r, r, (ratio * 360 - 90) * Math.PI / 180, -90 * Math.PI / 180, true);
    context.lineTo(r, r / 7);
    context.arc(r, r, r / 7 * 5, -90 * Math.PI / 180, (ratio * 360 - 90) * Math.PI / 180, false);
    context.fill();
    context.closePath();

    if (ratio < 0.99) {
        if (ratio == 0) {
            context.beginPath();
            context.fillStyle = lightColor;
            context.arc(r, r, r - 5, 0, 2 * Math.PI, false);
            context.lineTo(r - 4, r);
            context.arc(r, r, r / 4 * 3, 0, 2 * Math.PI, true);
            context.fill();
            context.closePath();
        } else {
            context.beginPath();
            context.fillStyle = lightColor;
            context.arc(r, r, r - 5, ((ratio + 0.01) * 360 - 90) * Math.PI / 180, -90 * Math.PI / 180, false);
            context.lineTo(r, r / 4);
            context.arc(r, r, r / 4 * 3, -90 * Math.PI / 180, ((ratio + 0.01) * 360 - 90) * Math.PI / 180, true);
            context.fill();
            context.closePath();

            context.beginPath();
            context.fillStyle = '#fff';
            context.arc(r, r, r, (0.99 * 360 - 90) * Math.PI / 180, -90 * Math.PI / 180, false);
            context.lineTo(r, r / 7);
            context.arc(r, r, r / 7 * 5, -90 * Math.PI / 180, (0.99 * 360 - 90) * Math.PI / 180, true);
            context.fill();
            context.closePath();
        }
    }

    var data = document.getElementById('data');
    ratio = (ratio * 100).toFixed(2);
    data.innerHTML = ratio + '<span class="percent">%</span>';
    var h = r / 2;
    data.style.fontSize = h / 8 * 6 + 'px';
    var dataWidth = parseInt(window.getComputedStyle(data, null).width);
    var dataHeight = parseInt(window.getComputedStyle(data, null).height);
    data.style.marginLeft = -dataWidth / 2 + 'px';
    data.style.marginTop = -dataHeight / 2 + 'px';
}

function barChart(data) {
    if (!data) {
        return;
    }
    var barContainer = document.getElementById('barContainer');
    var barContent = '<ul id="barGraph"></ul>';
    for(var lineIndex=0; i<10; i++){
        barContent += '<p class="line"></p>';
    }
    for(var bdIndex = 1; bdIndex <=26; bdIndex+=5){
        barContent += '<p class="barData">'+bdIndex+'</p>';
    }
    barContainer.innerHTML = barContent;
    var lC = '#F83536',
        mC = '#F7E33B',
        hC = '#B7DB27';
    var len = 30,
        barGraph = document.getElementById('barGraph');
    var dataLen = data.length;

    var height = parseInt(window.getComputedStyle(barGraph, null).height),
        width = parseInt(window.getComputedStyle(barGraph, null).width);
    var w = parseInt(width / len);
    var escape = width - w * len;
    var size = w / 7 * 5,
        collapse = w / 7 * 2;

    var lines = document.getElementsByClassName('line'),
        line;
    var totalWidth = (width - escape - collapse).toFixed(0);
    for (var i = 0, l = lines.length; i < l; i++) {
        line = lines[i];
        line.style.width = totalWidth + 'px';
        line.style.left = escape / 2 + 'px';
        line.style.height = height / 10 + 'px';
        line.style.top = i * height / 10 + 'px';
    }
    for (var i = 0; i < len; i++) {
        var li = document.createElement('li');
        var em = document.createElement('em');
        var backColor;
        if (data[i] <= 30) {
            backColor = lC;
        } else if (data[i] <= 60) {
            backColor = mC;
        } else {
            backColor = hC;
        }
        em.style.backgroundColor = backColor;
        em.style.height = height * data[i] / 100 + 'px';
        li.style.height = '100%';
        li.style.width = size + 'px';
        li.style.marginRight = collapse + 'px';
        barGraph.appendChild(li);
        li.appendChild(em);
    }
    var barDatas = document.getElementsByClassName('barData'),
        barData;
    for (var i = 0, l = barDatas.length; i < l; i++) {
        barData = barDatas[i];
        barData.style.left = escape / 2 + i * w * 5 + 'px';
    }
}

function lineChart(data) {
    if (!data) {
        return;
    }
    var line = document.getElementById('line');
    if(line){
         line.parentNode.removeChild(line);
    }
    var lineContainer = document.getElementById('lineContainer');
    lineContainer.innerHTML = '<canvas id="line"></canvas>';
    var len = 30;
    var lineChart = document.getElementById('line');
    var lineContent = document.getElementById('lineContent');
    if (!lineChart) {
        alert('浏览器不支持canvas功能')
    }
    var height = window.getComputedStyle(lineContent, null).height;
    var width = window.getComputedStyle(lineContent, null).width;
    height = parseInt(height) - 10;
    width = parseInt(width) - 10;
    var w = parseInt(width / len);
    var escape = width - w * len;
    width -= escape;

    lineChart.setAttribute('height', height + 10);
    lineChart.setAttribute('width', width + 10);

    var linePercent = document.getElementsByClassName('linePercent');
    var lineP, lineTitle, lineContent;
    for (var i = 0, l = linePercent.length; i < l; i++) {
        lineP = linePercent[i];
        lineTitle = lineP.getElementsByTagName('dt')[0];
        lineContent = lineP.getElementsByTagName('dd')[0];
        lineP.style.top = 5 + i * height / 5 + 'px';
        lineP.style.width = width + escape + 'px';
        lineContent.style.height = height / 10 + 'px';
    }

    var lineData = document.getElementsByClassName('lineData');
    for (var i = 0, l = lineData.length; i < l; i++) {
        lineData[i].style.left = 40 + i * w * 5 + 'px';
    }

    var borderColor = '#C4D2DE',
        longitudeColor = '#EDF3F7',
        parallelColor = '#CFDEEB',
        lineColor = '#60CD75',
        lineBackColor = '#DCFAE6';

    var context = lineChart.getContext('2d');
    var l = data.length - 1;

    context.beginPath();
    context.strokeStyle = longitudeColor;
    context.lineWidth = 1;
    for (var i = 0; i <= l; i++) {
        context.moveTo(5 + w * i, 5);
        context.lineTo(5 + w * i, 5 + height);
        context.stroke();
    }
    context.closePath();

    context.beginPath();
    context.translate(0, height);
    context.scale(1, -1);

    context.fillStyle = lineBackColor;
    context.strokeStyle = lineColor;
    context.lineWidth = 2;
    context.moveTo(5, -5);
    for (var i = 0; i <= l; i++) {
        context.lineTo(5 + i * w, height * data[i] / 100 - 5);
    }
    context.lineTo(5 + w * l, -5);
    context.fill();
    context.stroke();
    context.closePath();

    context.beginPath();
    context.strokeStyle = lineColor;
    context.fillStyle = '#fff';
    context.lineWidth = 2;
    for (var i = 0; i <= l; i++) {
        context.moveTo(5 + i * w, height * data[i] / 100 - 5);
        context.arc(5 + i * w, height * data[i] / 100 - 5, 3, 0, 2 * Math.PI / 180, true);
        context.stroke();
        context.fill();
    }
    context.closePath();
}

function log(text) {
    var div = document.getElementById('log');
    if (!div) {
        div = document.createElement('div');
        div.id = 'log';
        div.style.backgroundColor = '#ccc';
        div.style.position = 'fixed';
        div.style.left = '1px';
        div.style.top = '120px';
        div.style.zIndex = '30';
        document.body.appendChild(div);
    }
    div.innerHTML = div.innerHTML + '<br/>' + text;
}