/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzrb;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzrb zzamm;
    @Hide
    public static WeakHashMap<View, NativeAdViewHolder> zzamn = new WeakHashMap();
    private WeakReference<View> zzamo;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        zzbq.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView) {
            zzaky.e("The provided containerView is of type NativeAdView. NativeAdView objects should not be used with NativeAdViewHolder.");
            return;
        }
        if (zzamn.get(view) != null) {
            zzaky.e("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzamn.put(view, this);
        this.zzamo = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzd(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzd(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzamm = zzlc.zzik().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzd(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        View view = this.zzamo != null ? (View)this.zzamo.get() : null;
        if (view == null) {
            zzaky.zzcz("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzamn.containsKey(view)) {
            zzamn.put(view, this);
        }
        if (this.zzamm != null) {
            try {
                this.zzamm.zza((IObjectWrapper)nativeAd.zzbi());
                return;
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzamm != null) {
            try {
                this.zzamm.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzamo != null ? (View)this.zzamo.get() : null) != null) {
            zzamn.remove(view);
        }
    }
}

