/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzki;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zznc;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzso;
import com.google.android.gms.internal.zzsp;
import com.google.android.gms.internal.zzwf;
import com.google.android.gms.internal.zzyp;
import com.google.android.gms.internal.zzyq;
import java.util.HashMap;

@zzabh
@Hide
public class zzks {
    private zzmb zzbih;
    private final Object mLock = new Object();
    private final zzkj zzbii;
    private final zzki zzbij;
    private final zznc zzbik;
    private final zzso zzbil;
    private final zzafg zzbim;
    private final zzyp zzbin;
    private final zzsp zzbio;

    public zzks(zzkj zzkj2, zzki zzki2, zznc zznc2, zzso zzso2, zzafg zzafg2, zzyp zzyp2, zzsp zzsp2) {
        this.zzbii = zzkj2;
        this.zzbij = zzki2;
        this.zzbik = zznc2;
        this.zzbil = zzso2;
        this.zzbim = zzafg2;
        this.zzbin = zzyp2;
        this.zzbio = zzsp2;
    }

    @Nullable
    private static zzmb zzid() {
        try {
            Object obj = zzks.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzaky.zzcz("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzmc.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzaky.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzmb zzie() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbih == null) {
                this.zzbih = zzks.zzid();
            }
            return this.zzbih;
        }
    }

    @VisibleForTesting
    static <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        boolean bl2 = bl;
        if (!bl2) {
            zzlc.zzij();
            if (!zzako.zzbb(context)) {
                zzaky.zzby("Google Play Services is not available");
                bl2 = true;
            }
        }
        zzlc.zzij();
        int n = zzako.zzbd(context);
        zzlc.zzij();
        if (n > zzako.zzbc(context)) {
            bl2 = true;
        }
        if (bl2) {
            t = zza2.zzig();
            if (t == null) {
                t = zza2.zzih();
            }
        } else {
            t = zza2.zzih();
            if (t == null) {
                t = zza2.zzig();
            }
        }
        return t;
    }

    private static void zza(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzlc.zzij().zza(context, null, "gmob-apps", bundle, true);
    }

    public final zzlo zzb(Context context, String string, zzwf zzwf2) {
        zzkw zzkw2 = new zzkw(this, context, string, zzwf2);
        Context context2 = context;
        return zzks.zza(context2, false, zzkw2);
    }

    public final zzqw zza(Context context, FrameLayout frameLayout, FrameLayout frameLayout2) {
        zzky zzky2 = new zzky(this, frameLayout, frameLayout2, context);
        Context context2 = context;
        return zzks.zza(context2, false, zzky2);
    }

    public final zzrb zza(View view, HashMap<String, View> hashMap, HashMap<String, View> hashMap2) {
        zzkz zzkz2 = new zzkz(this, view, hashMap, hashMap2);
        Context context = view.getContext();
        return zzks.zza(context, false, zzkz2);
    }

    @Nullable
    public final zzyq zzb(Activity activity) {
        boolean bl;
        String string = "com.google.android.gms.ads.internal.overlay.useClientJar";
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzaky.e("useClientJar flag not found in activity intent extras.");
            bl = false;
        } else {
            bl = intent.getBooleanExtra(string, false);
        }
        return zzks.zza((Context)activity, bl, new zzlb(this, activity));
    }

    static /* synthetic */ zzkj zzb(zzks zzks2) {
        return zzks2.zzbii;
    }

    static /* synthetic */ void zza(zzks zzks2, Context context, String string) {
        zzks.zza(context, string);
    }

    static /* synthetic */ zzki zzc(zzks zzks2) {
        return zzks2.zzbij;
    }

    static /* synthetic */ zznc zzd(zzks zzks2) {
        return zzks2.zzbik;
    }

    static /* synthetic */ zzso zze(zzks zzks2) {
        return zzks2.zzbil;
    }

    static /* synthetic */ zzsp zzf(zzks zzks2) {
        return zzks2.zzbio;
    }

    static /* synthetic */ zzafg zzg(zzks zzks2) {
        return zzks2.zzbim;
    }

    static /* synthetic */ zzyp zzh(zzks zzks2) {
        return zzks2.zzbin;
    }

    @VisibleForTesting
    abstract class zza<T> {
        private /* synthetic */ zzks zzbis;

        zza(zzks zzks2) {
            this.zzbis = zzks2;
        }

        @Nullable
        protected abstract T zza(zzmb var1) throws RemoteException;

        @Nullable
        protected abstract T zzif() throws RemoteException;

        @Nullable
        protected final T zzig() {
            zzmb zzmb2 = this.zzbis.zzie();
            if (zzmb2 == null) {
                zzaky.zzcz("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zza(zzmb2);
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzih() {
            try {
                return this.zzif();
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

