/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzafh;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzkv;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzwe;

@zzabh
@Hide
public final class zzmy {
    private final zzwe zzbjr = new zzwe();
    private final Context mContext;
    private final zzkn zzaln;
    private AdListener zzbgu;
    private zzkf zzbgt;
    private zzlt zzbjw;
    private String zzapp;
    private AppEventListener zzamr;
    private PublisherInterstitialAd zzbkb;
    private OnCustomRenderedAdLoadedListener zzbjx;
    private Correlator zzbjv;
    private RewardedVideoAdListener zzgy;
    private boolean zzbkc;
    private boolean zzaqf;

    public zzmy(Context context) {
        this(context, zzkn.zzbhz, null);
    }

    public zzmy(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzkn.zzbhz, publisherInterstitialAd);
    }

    private zzmy(Context context, zzkn zzkn2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzaln = zzkn2;
        this.zzbkb = publisherInterstitialAd;
    }

    public final AdListener getAdListener() {
        return this.zzbgu;
    }

    public final String getAdUnitId() {
        return this.zzapp;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzamr;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzbjx;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzbjw == null) {
                return false;
            }
            return this.zzbjw.isReady();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzbjw == null) {
                return false;
            }
            return this.zzbjw.isLoading();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public final void zza(zzmu zzmu2) {
        try {
            if (this.zzbjw == null) {
                String string = "loadAd";
                zzmy zzmy2 = this;
                if (zzmy2.zzapp == null) {
                    zzmy2.zzak(string);
                }
                zzko zzko2 = zzmy2.zzbkc ? zzko.zzib() : new zzko();
                zzwe zzwe2 = zzmy2.zzbjr;
                String string2 = zzmy2.zzapp;
                zzko zzko3 = zzko2;
                Context context = zzmy2.mContext;
                zzks zzks2 = zzlc.zzik();
                zzkv zzkv2 = new zzkv(zzks2, context, zzko3, string2, zzwe2);
                Context context2 = context;
                zzmy2.zzbjw = zzks.zza(context2, false, zzkv2);
                if (zzmy2.zzbgu != null) {
                    zzmy2.zzbjw.zza(new zzkh(zzmy2.zzbgu));
                }
                if (zzmy2.zzbgt != null) {
                    zzmy2.zzbjw.zza(new zzkg(zzmy2.zzbgt));
                }
                if (zzmy2.zzamr != null) {
                    zzmy2.zzbjw.zza(new zzkq(zzmy2.zzamr));
                }
                if (zzmy2.zzbjx != null) {
                    zzmy2.zzbjw.zza(new zzpe(zzmy2.zzbjx));
                }
                if (zzmy2.zzbjv != null) {
                    zzmy2.zzbjw.zza(zzmy2.zzbjv.zzbf());
                }
                if (zzmy2.zzgy != null) {
                    zzmy2.zzbjw.zza(new zzafh(zzmy2.zzgy));
                }
                zzmy2.zzbjw.setImmersiveMode(zzmy2.zzaqf);
            }
            if (this.zzbjw.zzb(zzkn.zza(this.mContext, zzmu2))) {
                this.zzbjr.zzn(zzmu2.zziv());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzbgu = adListener;
            if (this.zzbjw != null) {
                this.zzbjw.zza(adListener != null ? new zzkh(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(zzkf zzkf2) {
        try {
            this.zzbgt = zzkf2;
            if (this.zzbjw != null) {
                this.zzbjw.zza(zzkf2 != null ? new zzkg(zzkf2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zzapp != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzapp = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzamr = appEventListener;
            if (this.zzbjw != null) {
                this.zzbjw.zza(appEventListener != null ? new zzkq(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzbjx = onCustomRenderedAdLoadedListener;
            if (this.zzbjw != null) {
                this.zzbjw.zza(onCustomRenderedAdLoadedListener != null ? new zzpe(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzbjv = correlator;
        try {
            if (this.zzbjw != null) {
                this.zzbjw.zza(this.zzbjv == null ? null : this.zzbjv.zzbf());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzgy = rewardedVideoAdListener;
            if (this.zzbjw != null) {
                this.zzbjw.zza(rewardedVideoAdListener != null ? new zzafh(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(boolean bl) {
        this.zzbkc = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbjw != null) {
                return this.zzbjw.zzco();
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final void show() {
        try {
            this.zzak("show");
            this.zzbjw.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to show interstitial.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzaqf = bl;
            if (this.zzbjw != null) {
                this.zzbjw.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set immersive mode", remoteException);
            return;
        }
    }

    private final void zzak(String string) {
        if (this.zzbjw == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

