/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzro;
import java.util.List;
import java.util.WeakHashMap;

@zzabh
@Hide
public final class zzrr
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzrr> zzcap = new WeakHashMap();
    private final zzro zzcaq;
    private final MediaView zzcar;
    private final VideoController zzbjt = new VideoController();

    private zzrr(zzro zzro2) {
        this.zzcaq = zzro2;
        Context context = null;
        try {
            context = (Context)zzn.zzy((IObjectWrapper)zzro2.zzkk());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzaky.zzb("Unable to inflate MediaView.", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Context context2 = context;
            mediaView = new MediaView(context2);
            try {
                if (!this.zzcaq.zzf(zzn.zzz((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                zzaky.zzb("Unable to render video in MediaView.", remoteException);
            }
        }
        this.zzcar = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzrr zza(zzro zzro2) {
        WeakHashMap<IBinder, zzrr> weakHashMap = zzcap;
        synchronized (weakHashMap) {
            zzrr zzrr2 = zzcap.get(zzro2.asBinder());
            if (zzrr2 != null) {
                return zzrr2;
            }
            zzrr2 = new zzrr(zzro2);
            zzcap.put(zzro2.asBinder(), zzrr2);
            return zzrr2;
        }
    }

    public final zzro zzkx() {
        return this.zzcaq;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzcaq.zzap(string);
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get string.", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzqs zzqs2 = this.zzcaq.zzaq(string);
            if (zzqs2 != null) {
                return new zzqv(zzqs2);
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get image.", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzmm zzmm2 = this.zzcaq.getVideoController();
            if (zzmm2 != null) {
                this.zzbjt.zza(zzmm2);
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzbjt;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzcar;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzcaq.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get available asset names.", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzcaq.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get custom template id.", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzcaq.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to perform click.", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzcaq.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to record impression.", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzcaq.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to destroy ad.", remoteException);
            return;
        }
    }
}

