/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbic;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzaa
implements zzcc {
    private final Map<Api.zzc<?>, zzz<?>> zzfwg = new HashMap();
    private final Map<Api.zzc<?>, zzz<?>> zzfwh = new HashMap();
    private final Map<Api<?>, Boolean> zzfwi;
    private final zzbm zzfsq;
    private final zzba zzfwj;
    private final Lock zzfwa;
    private final Looper zzalj;
    private final zzf zzfwk;
    private final Condition zzfwl;
    private final zzr zzfwf;
    private final boolean zzfwm;
    private final boolean zzfwn;
    private final Queue<zzm<?, ?>> zzfwo = new LinkedList();
    private boolean zzfwp;
    private Map<zzh<?>, ConnectionResult> zzfwq;
    private Map<zzh<?>, ConnectionResult> zzfwr;
    private zzad zzfws;
    private ConnectionResult zzfwt;

    public zzaa(Context context, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcyj, zzcyk> zza2, ArrayList<zzt> arrayList, zzba zzba2, boolean bl) {
        this.zzfwa = lock;
        this.zzalj = looper;
        this.zzfwl = lock.newCondition();
        this.zzfwk = zzf2;
        this.zzfwj = zzba2;
        this.zzfwi = map2;
        this.zzfwf = zzr2;
        this.zzfwm = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzahm(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzt> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList2.get(i);
            zzt zzt3 = zzt2;
            hashMap2.put(zzt3.zzfop, zzt3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze2 = entry.getValue();
            if (zze2.zzahn()) {
                bl4 = true;
                if (!this.zzfwi.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzt zzt4 = (zzt)hashMap2.get(api);
            zzz zzz2 = new zzz(context, api, looper, zze2, zzt4, zzr2, zza2);
            this.zzfwg.put(entry.getKey(), zzz2);
            if (!zze2.zzacc()) continue;
            this.zzfwh.put(entry.getKey(), zzz2);
        }
        this.zzfwn = bl4 && !bl3 && !bl2;
        this.zzfsq = zzbm.zzajy();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzfwm && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzfwo.add(t);
            return t;
        }
        this.zzfwj.zzfyp.zzb(t);
        return this.zzfwg.get(t.zzahm()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzahm();
        if (this.zzfwm && this.zzg(t)) {
            return t;
        }
        this.zzfwj.zzfyp.zzb(t);
        return this.zzfwg.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzahm();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzu(new Status(4, null, this.zzfsq.zza(this.zzfwg.get(zzc2).zzahv(), System.identityHashCode(this.zzfwj))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzfwa.lock();
        try {
            if (this.zzfwp) {
                return;
            }
            this.zzfwp = true;
            this.zzfwq = null;
            this.zzfwr = null;
            this.zzfws = null;
            this.zzfwt = null;
            this.zzfsq.zzaih();
            this.zzfsq.zza(this.zzfwg.values()).addOnCompleteListener((Executor)new zzbic(this.zzalj), (OnCompleteListener)new zzac(this, null));
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfwl.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfqt;
        }
        if (this.zzfwt != null) {
            return this.zzfwt;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfwl.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfqt;
        }
        if (this.zzfwt != null) {
            return this.zzfwt;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzfwa.lock();
        try {
            this.zzfwp = false;
            this.zzfwq = null;
            this.zzfwr = null;
            if (this.zzfws != null) {
                this.zzfws.cancel();
                this.zzfws = null;
            }
            this.zzfwt = null;
            while (!this.zzfwo.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzfwo.remove();
                ((BasePendingResult)zzm2).zza((zzdn)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfwl.signalAll();
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzahm());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzfwa.lock();
        try {
            zzz<?> zzz2 = this.zzfwg.get(zzc2);
            if (this.zzfwq != null && zzz2 != null) {
                ConnectionResult connectionResult = this.zzfwq.get(zzz2.zzahv());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzfwa.lock();
        try {
            boolean bl = this.zzfwq != null && this.zzfwt == null;
            return bl;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfwa.lock();
        try {
            boolean bl = this.zzfwq == null && this.zzfwp;
            return bl;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    private final boolean zzaiy() {
        this.zzfwa.lock();
        try {
            if (!this.zzfwp || !this.zzfwm) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzfwh.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        this.zzfwa.lock();
        try {
            if (this.zzfwp && !this.zzaiy()) {
                this.zzfsq.zzaih();
                this.zzfws = new zzad(this, zzcu2);
                this.zzfsq.zza(this.zzfwh.values()).addOnCompleteListener((Executor)new zzbic(this.zzalj), (OnCompleteListener)this.zzfws);
                return true;
            }
            return false;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void zzaia() {
        this.zzfwa.lock();
        try {
            this.zzfsq.zzaia();
            if (this.zzfws != null) {
                this.zzfws.cancel();
                this.zzfws = null;
            }
            if (this.zzfwr == null) {
                this.zzfwr = new ArrayMap(this.zzfwh.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzz<?> zzz2 : this.zzfwh.values()) {
                this.zzfwr.put(zzz2.zzahv(), connectionResult);
            }
            if (this.zzfwq != null) {
                this.zzfwq.putAll(this.zzfwr);
            }
            return;
        }
        finally {
            this.zzfwa.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzais() {
    }

    private final void zzaiz() {
        if (this.zzfwf == null) {
            this.zzfwj.zzfyk = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzfwf.zzamf());
        Map<Api<?>, com.google.android.gms.common.internal.zzt> map = this.zzfwf.zzamh();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzenh);
        }
        this.zzfwj.zzfyk = hashSet;
    }

    private final void zzaja() {
        while (!this.zzfwo.isEmpty()) {
            this.zze(this.zzfwo.remove());
        }
        this.zzfwj.zzk(null);
    }

    private final boolean zza(zzz<?> zzz2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzfwi.get(zzz2.zzaht()) != false && zzz2.zzaix().zzahn() && this.zzfwk.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzajb() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzz<?> zzz2 : this.zzfwg.values()) {
            int n3;
            Api api = zzz2.zzaht();
            zzh zzh2 = zzz2.zzahv();
            ConnectionResult connectionResult3 = this.zzfwq.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzfwi.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzfwk.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzfwm) {
                n3 = api.zzahk().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzahk().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzaa zzaa2) {
        return zzaa2.zzfwa;
    }

    static /* synthetic */ boolean zzb(zzaa zzaa2) {
        return zzaa2.zzfwp;
    }

    static /* synthetic */ Map zza(zzaa zzaa2, Map map) {
        zzaa2.zzfwq = map;
        return zzaa2.zzfwq;
    }

    static /* synthetic */ Map zzc(zzaa zzaa2) {
        return zzaa2.zzfwg;
    }

    static /* synthetic */ Map zzd(zzaa zzaa2) {
        return zzaa2.zzfwq;
    }

    static /* synthetic */ boolean zze(zzaa zzaa2) {
        return zzaa2.zzfwn;
    }

    static /* synthetic */ boolean zza(zzaa zzaa2, zzz zzz2, ConnectionResult connectionResult) {
        return zzaa2.zza(zzz2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzaa zzaa2, ConnectionResult connectionResult) {
        zzaa2.zzfwt = connectionResult;
        return zzaa2.zzfwt;
    }

    static /* synthetic */ ConnectionResult zzf(zzaa zzaa2) {
        return zzaa2.zzajb();
    }

    static /* synthetic */ Map zzg(zzaa zzaa2) {
        return zzaa2.zzfwr;
    }

    static /* synthetic */ ConnectionResult zzh(zzaa zzaa2) {
        return zzaa2.zzfwt;
    }

    static /* synthetic */ void zzi(zzaa zzaa2) {
        zzaa2.zzaiz();
    }

    static /* synthetic */ void zzj(zzaa zzaa2) {
        zzaa2.zzaja();
    }

    static /* synthetic */ boolean zza(zzaa zzaa2, boolean bl) {
        zzaa2.zzfwp = false;
        return false;
    }

    static /* synthetic */ zzba zzk(zzaa zzaa2) {
        return zzaa2.zzfwj;
    }

    static /* synthetic */ Condition zzl(zzaa zzaa2) {
        return zzaa2.zzfwl;
    }

    static /* synthetic */ Map zzb(zzaa zzaa2, Map map) {
        zzaa2.zzfwr = map;
        return zzaa2.zzfwr;
    }

    static /* synthetic */ Map zzm(zzaa zzaa2) {
        return zzaa2.zzfwh;
    }
}

