precision mediump float;
varying vec2 v_texture_position;
varying vec2 v_noise_position;

uniform sampler2D map_texture;
uniform sampler2D background_texture;
uniform vec3 background_color;

#ifdef DEBUG_RENDERING
uniform vec3 debug_color;
#endif

const lowp float threshold = 0.25;

void main() {
  lowp float shading = 1.0;
  lowp vec4 Csample = texture2D(map_texture, v_texture_position);
  lowp vec3 color = Csample.rgb;

  lowp float C = Csample.a;

  #ifdef DEBUG_RENDERING
  if (debug_color != vec3(0.0, 0.0, 0.0))
    color = color * 0.3 + debug_color * 0.7;
  #endif

  if(C <= threshold * 3.0 && C > threshold * 2.5) {
    lowp float x = (C - threshold * 2.5) / (threshold * 0.5);
    gl_FragColor = vec4(color * x, 1.0);
  } else if(C <= threshold * 2.5 && C > threshold * 1.5) {
    gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
  } else if(C <= threshold * 1.5 && C > threshold) {
    lowp float x = (threshold * 1.5 - C) / (threshold * 0.5);
    gl_FragColor = vec4(background_color * x, 1.0);
  } else if(C <= threshold) {
    gl_FragColor = vec4(background_color, 1.0);
  } else {
    gl_FragColor = vec4(color, 1.0);
  }
}
