attribute vec2 vertex_position;

varying vec2 v_noise_position;

uniform float background_cache_size;
uniform float background_size;

uniform mat3 transform;

void main() {
  vec3 transformed_position = transform * vec3(vertex_position, 1.0);
  gl_Position = vec4(transformed_position.xy, 0.0, transformed_position.z);

  v_noise_position = vertex_position.xy / background_size * vec2(-1.0, 1.0);
}
