
attribute vec2 vertex_position;
attribute vec2 slide_direction;
attribute float center_distance;

varying float v_center_distance;

uniform float gradient_end;
uniform float gradient_length;

void main() {
  gl_Position = vec4(vertex_position + slide_direction * max(gradient_end, 0.0), 0.0, 1.0);

  v_center_distance = (center_distance - min(gradient_end, 0.0)) / gradient_length;
}
