precision mediump float;
varying vec2 v_map_texture_position;
varying vec2 v_decal_texture_position;

uniform sampler2D map_texture;
uniform sampler2D decal_texture;

#ifdef DEBUG_RENDERING
uniform vec3 debug_color;
#endif

const lowp float threshold = 0.35;
const lowp float edge_offset = 0.0018;

void main() {
  lowp float B = texture2D(map_texture, v_map_texture_position + vec2(-edge_offset, +edge_offset)).a;
  lowp float C = texture2D(map_texture, v_map_texture_position).a;
  lowp float D = texture2D(map_texture, v_map_texture_position + vec2(+edge_offset, -edge_offset)).a;

  if(C < threshold) {
    gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    lowp float shading = 1.0;
    if(B < threshold)      shading = 1.3;
    else if(D < threshold) shading = 0.7;

    lowp vec4 color = texture2D(decal_texture, v_decal_texture_position);

    #ifdef DEBUG_RENDERING
    if (debug_color != vec3(0.0, 0.0, 0.0))
      color.rgb = color.rgb * 0.3 + debug_color * 0.7;
    #endif

    gl_FragColor = vec4(color.rgb * shading, color.a);
  }

//   gl_FragColor = vec4(C, 1.0, 0.0, 1.0); // XXX
}
