attribute vec2 vertex_position;
attribute vec2 decal_texture_position;

varying vec2 v_map_texture_position;
varying vec2 v_decal_texture_position;

uniform vec2 scroll;
uniform float ground_cache_size;
uniform float zoom;

// TODO: Pass in externally?
#define MAP_SIZE_IN_PIXELS (512.0 * 4.0)

void main() {
  gl_Position = vec4(((vertex_position - scroll) * zoom / ground_cache_size * 2.0 - vec2(1.0, 1.0)), 0.0, 1.0);

  v_map_texture_position = vertex_position / MAP_SIZE_IN_PIXELS;
  v_map_texture_position.y = 1.0 - v_map_texture_position.y;

  v_decal_texture_position = decal_texture_position;
}
