attribute vec2 vertex_position;
varying vec2 v_texture_position;
varying vec2 v_noise_position;

uniform float ground_cache_size;
uniform float ground_size;
uniform mediump float zoom;
uniform vec2 vertex_shift;

// TODO: Pass in externally?
#define MAP_SIZE_IN_PIXELS (512.0 * 4.0)

void main() {
  gl_Position = vec4((vertex_position + vertex_shift) / ground_cache_size * zoom * 2.0 /* because of -1.0 to +1.0 axis */ - vec2(1.0, 1.0), 0.0, 1.0);
  v_texture_position = vertex_position / MAP_SIZE_IN_PIXELS;
  v_texture_position.y = 1.0 - v_texture_position.y;
  v_noise_position = vertex_position / ground_size;
}
