// precision - see ground.frag
precision highp float;
varying vec2 v_texture_position;
varying vec2 v_noise_position;

uniform sampler2D map_texture;
uniform sampler2D ground_texture;

#ifdef DEBUG_RENDERING
uniform vec3 debug_color;
#endif

const float threshold = 0.35;

void main() {
  float shading = 1.0;
  vec4 Csample = texture2D(map_texture, v_texture_position);
  vec3 color = Csample.rgb;

  float C = Csample.a;

  #ifdef DEBUG_RENDERING
  if (debug_color != vec3(0.0, 0.0, 0.0))
    color = color * 0.3 + debug_color * 0.7;
  #endif

  if(C <= 0.85 && C > threshold) {
    gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
  } else if(C <= threshold) {
    gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    gl_FragColor = vec4(color, 1.0);
  }
}
