attribute vec2 vertex_position;
attribute float color_select;

varying vec3 v_vertex_color;
varying vec2 v_noise_position;

uniform mat3 transform;
uniform vec3 ground_color_0;
uniform vec3 ground_color_1;
uniform float ground_size;

void main() {
  vec3 transformed_position = transform * vec3(vertex_position, 1.0);
  gl_Position = vec4(transformed_position.xy, 0.0, transformed_position.z);

  v_vertex_color = mix(ground_color_0, ground_color_1, color_select);
  v_noise_position = vertex_position.xy / ground_size;
}
