// precision - see ground.frag
precision highp float;
varying vec2 v_texture_position;
varying vec2 v_noise_position;

uniform sampler2D map_texture;
uniform sampler2D background_texture;
uniform vec3 background_color;

#ifdef DEBUG_RENDERING
uniform vec3 debug_color;
#endif

const float threshold = 0.35;

void main() {
  float shading = 1.0;
  vec4 Csample = texture2D(map_texture, v_texture_position);
  vec3 color = Csample.rgb;

  float A = texture2D(map_texture, v_texture_position + vec2(-0.005, +0.005)).a;
  float B = texture2D(map_texture, v_texture_position + vec2(-0.0015, +0.0015)).a;
  float C = Csample.a;
  float D = texture2D(map_texture, v_texture_position + vec2(+0.0015, -0.0015)).a;

  vec3 noise = vec3(1.0);

  if(C < threshold) {
    color = background_color;

    if(A > threshold) shading = 0.6;
    else              shading = 0.5;
  } else {
    if(B < threshold)      shading = -0.1;
    else if(D < threshold) shading = 0.1;
    else                   shading = 0.0;

    noise = texture2D(background_texture, v_noise_position).rgb;
  }

  #ifdef DEBUG_RENDERING
  if (debug_color != vec3(0.0, 0.0, 0.0))
    color = color * 0.3 + debug_color * 0.7;
  #endif

  gl_FragColor = vec4(noise * color - shading, 1.0);
}
