// precision - see ground.frag
precision highp float;
varying vec2 v_texture_position;
varying vec2 v_noise_position;

uniform sampler2D map_texture;
uniform sampler2D ground_texture;

#ifdef DEBUG_RENDERING
uniform vec3 debug_color;
#endif

const float threshold = 0.35;
const float edge_offset = 0.0015;

void main() {
  float shading = 1.0;
  vec4 Csample = texture2D(map_texture, v_texture_position);
  vec3 color = Csample.rgb;

  #ifdef DEBUG_RENDERING
  if (debug_color != vec3(0.0, 0.0, 0.0))
    color = color * 0.3 + debug_color * 0.7;
  #endif

  if(Csample.a < threshold) {
    gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    float B = texture2D(map_texture, v_texture_position + vec2(-edge_offset, +edge_offset)).a;
    float D = texture2D(map_texture, v_texture_position + vec2(+edge_offset, -edge_offset)).a;
    vec3 noise = texture2D(ground_texture, v_noise_position).rgb;

    float shading = 0.2;
    if(B < threshold)      shading = -0.2;
    else if(D < threshold) shading = -0.2;

    gl_FragColor = vec4(noise * color - shading, 1.0);
  }

//   gl_FragColor = vec4(C, C, C, 1.0);
}
