precision mediump float;
varying vec2 v_texture_position;
varying vec2 v_noise_position;

uniform sampler2D map_texture;
uniform sampler2D background_texture;
uniform vec3 background_color;

#ifdef DEBUG_RENDERING
uniform vec3 debug_color;
#endif

const lowp float threshold = 0.25;

void main() {
  lowp float shading = 1.0;
  lowp vec4 Csample = texture2D(map_texture, v_texture_position);
  lowp vec3 color = Csample.rgb;

  lowp float B = texture2D(map_texture, v_texture_position + vec2(-0.0015, +0.0015)).a;
  lowp float C = Csample.a;
  lowp float D = texture2D(map_texture, v_texture_position + vec2(+0.0015, -0.0015)).a;

  lowp vec4 noise = texture2D(background_texture, v_noise_position);
  if(C < threshold) {
    color = noise.rgb;

    shading = 0.0;

  } else {
    if(B < threshold)      shading = 0.1;
    else if(D < threshold) shading = 0.3;
    else                   shading = 0.2;
    color *= (noise.a / 3.0 + 0.5);
  }

  #ifdef DEBUG_RENDERING
  if (debug_color != vec3(0.0, 0.0, 0.0))
    color = color * 0.3 + debug_color * 0.7;
  #endif

  gl_FragColor = vec4(color - shading, 1.0);
}
