uniform float zoom;

attribute vec2 position;

attribute float point_size;
varying float v_point_size;

attribute vec2 texture_position;
varying vec2 v_texture_position;

attribute vec3 vertex_color;
varying vec3 v_vertex_color;

void main() {
  gl_Position = vec4(position, 0.0, 1.0);
  v_texture_position = texture_position;
  gl_PointSize = v_point_size = point_size / 2.0 * zoom; // This allows us to save lot of space in VBO
  v_vertex_color = vertex_color;
}
