precision highp float;
varying vec2 v_texture_position;
uniform sampler2D texture;
uniform vec3 color;

void main() {
  vec4 col = texture2D(texture, v_texture_position);

  if(col.a != 0.0 && abs(col.g - col.b) < 0.02 && col.r > col.g) {
    float max = col.r;
    float min = col.g;

    col.rgb = color * (max - min) + vec3(min, min, min);
  }

  gl_FragColor = col;
}
