attribute vec4 vertex_color;
attribute vec2 vertex_position;
attribute vec2 texture_position;
varying vec4 v_vertex_color;
varying vec2 v_texture_position;
uniform vec2 translate;
uniform vec2 resolution;
uniform float opacity;

void main() {
  gl_Position = vec4(vertex_position, 0.0, 1.0);
  gl_Position.xy += translate;
  gl_Position.xy *= vec2(1.0/resolution.x, 1.0/resolution.y) * 2.0;
  gl_Position.xy -= vec2(1.0, 1.0);
  gl_Position.y = -gl_Position.y;
  v_texture_position = texture_position;
  v_vertex_color = vertex_color * vec4(1.0, 1.0, 1.0, opacity);
}
