attribute vec2 vertex_position;
attribute vec2 texture_position;
attribute float vertex_alpha;

varying vec2 v_texture_position;
varying float v_vertex_alpha;

uniform mat3 transform;

void main() {
  vec3 transformed_position = transform * vec3(vertex_position, 1.0);
  gl_Position = vec4(transformed_position.xy, 0.0, transformed_position.z);

  v_texture_position = texture_position;

  v_vertex_alpha = vertex_alpha;
}
