/*
 * Decompiled with CFR 0.152.
 */
package com.distriqt.core.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Base64;
import com.adobe.fre.FREBitmapData;
import com.distriqt.core.utils.FREUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class FREImageUtils {
    public static final String TAG = FREImageUtils.class.getSimpleName();
    private static final float[] bgrToRgbColorTransform = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final ColorMatrix colorMatrix = new ColorMatrix(bgrToRgbColorTransform);
    private static final ColorMatrixColorFilter colorFilter = new ColorMatrixColorFilter(colorMatrix);

    public static File bitmapDataToCacheFile(Context context, FREBitmapData bitmapData, String directory, String fileName) {
        return FREImageUtils.bitmapDataToCacheFile(context, bitmapData, directory, fileName, "jpg", 0.8f);
    }

    public static File bitmapDataToCacheFile(Context context, FREBitmapData bitmapData, String directory, String fileName, String format, float quality) {
        FREUtils.log(TAG, "bitmapDataToCacheFile()", new Object[0]);
        try {
            Bitmap encodingBitmap = FREImageUtils.bitmapDataToBitmap(bitmapData);
            if (encodingBitmap != null) {
                File outputDir = new File(context.getExternalCacheDir().getAbsolutePath() + "/" + directory);
                outputDir.mkdir();
                String outputFilePath = outputDir.getAbsolutePath() + "/" + fileName;
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(outputFilePath));
                if (format.equals("png")) {
                    encodingBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                } else {
                    encodingBitmap.compress(Bitmap.CompressFormat.JPEG, (int)(quality * 100.0f), (OutputStream)stream);
                }
                stream.flush();
                stream.close();
                return new File(outputFilePath);
            }
        }
        catch (Exception e) {
            FREUtils.handleException(null, e);
        }
        return null;
    }

    public static Bitmap bitmapDataToBitmap(FREBitmapData bitmapData) {
        FREUtils.log(TAG, "bitmapDataToBitmap()", new Object[0]);
        if (bitmapData != null) {
            try {
                bitmapData.acquire();
                ByteBuffer bitmapBytes = bitmapData.getBits();
                int width = bitmapData.getWidth();
                int height = bitmapData.getHeight();
                Bitmap encodingBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(encodingBitmap);
                encodingBitmap.copyPixelsFromBuffer((Buffer)bitmapBytes);
                bitmapData.release();
                Paint paint = new Paint();
                paint.setColorFilter((ColorFilter)colorFilter);
                canvas.drawBitmap(encodingBitmap, 0.0f, 0.0f, paint);
                return encodingBitmap;
            }
            catch (Exception e) {
                FREUtils.handleException(null, e);
            }
        }
        return null;
    }

    public static Bitmap getFREObjectAsBitmap(FREBitmapData object) throws Exception {
        object.acquire();
        Bitmap bmp = Bitmap.createBitmap((int)object.getWidth(), (int)object.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.copyPixelsFromBuffer((Buffer)object.getBits());
        object.release();
        float[] bgrToRgbColorTransform = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        ColorMatrix colorMatrix = new ColorMatrix(bgrToRgbColorTransform);
        ColorMatrixColorFilter colorFilter = new ColorMatrixColorFilter(colorMatrix);
        Canvas canvas = new Canvas(bmp);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)colorFilter);
        canvas.drawBitmap(bmp, 0.0f, 0.0f, paint);
        return bmp;
    }

    public static void drawBitmapToBitmapData(Bitmap bitmap, FREBitmapData bitmapData) {
        Bitmap encodingBitmap = null;
        Canvas canvas = null;
        Paint paint = null;
        float[] bgrToRgbColorTransform = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        ColorMatrix colorMatrix = new ColorMatrix(bgrToRgbColorTransform);
        ColorMatrixColorFilter colorFilter = new ColorMatrixColorFilter(colorMatrix);
        try {
            encodingBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            canvas = new Canvas(encodingBitmap);
            paint = new Paint();
            paint.setColorFilter((ColorFilter)colorFilter);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
            bitmapData.acquire();
            encodingBitmap.copyPixelsToBuffer((Buffer)bitmapData.getBits());
            bitmapData.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap getThumbnail(Context context, Uri uri, int thumbnailSize) throws FileNotFoundException, IOException {
        InputStream input = context.getContentResolver().openInputStream(uri);
        BitmapFactory.Options onlyBoundsOptions = new BitmapFactory.Options();
        onlyBoundsOptions.inJustDecodeBounds = true;
        onlyBoundsOptions.inDither = true;
        onlyBoundsOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)onlyBoundsOptions);
        input.close();
        if (onlyBoundsOptions.outWidth == -1 || onlyBoundsOptions.outHeight == -1) {
            return null;
        }
        int originalSize = onlyBoundsOptions.outHeight > onlyBoundsOptions.outWidth ? onlyBoundsOptions.outHeight : onlyBoundsOptions.outWidth;
        double ratio = originalSize > thumbnailSize ? (double)(originalSize / thumbnailSize) : 1.0;
        BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
        bitmapOptions.inSampleSize = FREImageUtils.getPowerOfTwoForSampleRatio(ratio);
        bitmapOptions.inDither = true;
        bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
        input = context.getContentResolver().openInputStream(uri);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)bitmapOptions);
        input.close();
        return bitmap;
    }

    private static int getPowerOfTwoForSampleRatio(double ratio) {
        int k = Integer.highestOneBit((int)Math.floor(ratio));
        if (k == 0) {
            return 1;
        }
        return k;
    }

    public static String drawBitmapToBitmapDataBase64String(Bitmap bitmap) {
        try {
            int[] pixels = new int[bitmap.getWidth() * bitmap.getHeight()];
            bitmap.getPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
            ByteBuffer buffer = ByteBuffer.allocate(pixels.length * 4);
            buffer.asIntBuffer().put(pixels);
            return Base64.encodeToString((byte[])buffer.array(), (int)2);
        }
        catch (Exception e) {
            FREUtils.handleException(e);
            return "";
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap = null;
        if (drawable != null) {
            BitmapDrawable bitmapDrawable;
            if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
                FREUtils.log(TAG, "drawableToBitmap(): returning BitmapDrawable", new Object[0]);
                return bitmapDrawable.getBitmap();
            }
            if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
                bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            } else {
                FREUtils.log(TAG, "drawableToBitmap(): Bitmap.createBitmap( %d, %d )", drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
        }
        return bitmap;
    }

    public static FREBitmapData bitmapToFREBitmapData(Bitmap image) {
        FREBitmapData bitmapData = null;
        try {
            Byte[] fillColor = new Byte[]{(byte)-1, (byte)-1, (byte)-1, (byte)-1};
            bitmapData = FREBitmapData.newBitmapData((int)image.getWidth(), (int)image.getHeight(), (boolean)image.hasAlpha(), (Byte[])fillColor);
            FREImageUtils.drawBitmapToBitmapData(image, bitmapData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmapData;
    }

    public static FREBitmapData bitmapToFREBitmapDataIgnoreOrder(Bitmap image) {
        FREBitmapData bitmapData = null;
        try {
            Byte[] fillColor = new Byte[]{(byte)-1, (byte)-1, (byte)-1, (byte)-1};
            bitmapData = FREBitmapData.newBitmapData((int)image.getWidth(), (int)image.getHeight(), (boolean)image.hasAlpha(), (Byte[])fillColor);
            FREImageUtils.drawBitmapToBitmapDataIgnoreOrder(image, bitmapData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmapData;
    }

    public static Bitmap getFREObjectAsBitmapIgnoreOrder(FREBitmapData object) throws Exception {
        object.acquire();
        Bitmap bmp = Bitmap.createBitmap((int)object.getWidth(), (int)object.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.copyPixelsFromBuffer((Buffer)object.getBits());
        object.release();
        return bmp;
    }

    public static void drawBitmapToBitmapDataIgnoreOrder(Bitmap bitmap, FREBitmapData bitmapData) {
        try {
            bitmapData.acquire();
            bitmap.copyPixelsToBuffer((Buffer)bitmapData.getBits());
            bitmapData.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

