/*
 * Decompiled with CFR 0.152.
 */
package com.distriqt.core.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import com.distriqt.core.utils.Assets;
import com.distriqt.core.utils.FREUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class FileProviderUtils {
    public static final String TAG = FileProviderUtils.class.getName();
    private static final String FILEPROVIDER_SUFFIX = ".fileprovider";

    public static Uri copyAssetToProvider(Context context, String path) {
        return FileProviderUtils.copyAssetToProvider(context, path, context.getPackageName() + FILEPROVIDER_SUFFIX);
    }

    public static Uri copyAssetToProvider(Context context, String authority, String path) {
        FREUtils.log(TAG, "copyAssetToProvider( %s )", path);
        if (!Assets.exists(context, path)) {
            return null;
        }
        Uri uri = null;
        try {
            String assetName = path.substring(0, 1).equals("/") ? path.substring(1) : path;
            String assetFileName = assetName.replace("/", "_");
            File dir = new File(context.getFilesDir(), ".distriqt_files");
            dir.mkdirs();
            File of = new File(dir, assetFileName);
            if (!of.exists()) {
                FileOutputStream outputStream = new FileOutputStream(of);
                InputStream assetInputStream = context.getAssets().open(assetName);
                FileProviderUtils.copyFile(assetInputStream, outputStream);
                outputStream.close();
                assetInputStream.close();
            }
            return FileProviderUtils.getUriForFile(context, authority, of);
        }
        catch (Exception e) {
            e.printStackTrace();
            return uri;
        }
    }

    public static Uri copyFileToProvider(Context context, String path) {
        return FileProviderUtils.copyFileToProvider(context, path, true);
    }

    public static Uri copyFileToProvider(Context context, String path, boolean overwrite) {
        String defaultAuthority = context.getPackageName() + FILEPROVIDER_SUFFIX;
        return FileProviderUtils.copyFileToProvider(context, defaultAuthority, path, overwrite);
    }

    public static Uri copyFileToProvider(Context context, String authority, String path, boolean overwrite) {
        FREUtils.log(TAG, "copyFileToProvider( %s )", path);
        Uri uri = null;
        try {
            File f;
            if (path.substring(0, 7).equals("file://")) {
                path = path.substring(7);
            }
            if ((f = new File(path)).exists()) {
                FREUtils.log(TAG, "making dir", new Object[0]);
                File dir = new File(context.getFilesDir(), ".distriqt_files");
                dir.mkdirs();
                File of = new File(dir, f.getName());
                if (overwrite && of.exists()) {
                    of.delete();
                }
                if (!of.exists()) {
                    FREUtils.log(TAG, "copying file to file provider location", new Object[0]);
                    FileOutputStream outputStream = new FileOutputStream(of);
                    FileInputStream inputStream = new FileInputStream(new File(path));
                    FileProviderUtils.copyFile(inputStream, outputStream);
                    outputStream.close();
                    inputStream.close();
                } else {
                    FREUtils.log(TAG, "file provider file exists", new Object[0]);
                }
                return FileProviderUtils.getUriForFile(context, authority, of);
            }
            FREUtils.log(TAG, "file doesn't exist", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uri;
    }

    @SuppressLint(value={"InlinedApi"})
    public static void grantPermissions(Context context, Intent intent, Uri uri) {
        List resInfoList = Build.VERSION.SDK_INT >= 23 ? context.getPackageManager().queryIntentActivities(intent, 131072) : context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : resInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, uri, 3);
        }
    }

    public static void copyFile(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    private static Uri getUriForFile(Context context, String authority, File of) {
        FREUtils.log(TAG, "getUriForFile( ..., %s, %s )", authority, of.getAbsolutePath());
        Uri uri = null;
        try {
            uri = FileProvider.getUriForFile((Context)context, (String)authority, (File)of);
        }
        catch (Exception e) {
            String defaultAuthority = context.getPackageName() + FILEPROVIDER_SUFFIX;
            if (!authority.equals(defaultAuthority)) {
                FREUtils.log(TAG, "getUriForFile( ..., %s, %s )", defaultAuthority, of.getAbsolutePath());
                uri = FileProvider.getUriForFile((Context)context, (String)defaultAuthority, (File)of);
            }
            throw e;
        }
        return uri;
    }
}

