/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzavi;
import com.google.android.gms.internal.ads.zzavj;
import com.google.android.gms.internal.ads.zzavk;
import com.google.android.gms.internal.ads.zzavl;
import com.google.android.gms.internal.ads.zzavm;
import com.google.android.gms.internal.ads.zzavn;
import com.google.android.gms.internal.ads.zzavo;
import com.google.android.gms.internal.ads.zzavp;
import com.google.android.gms.internal.ads.zzavq;
import com.google.android.gms.internal.ads.zzavr;
import com.google.android.gms.internal.ads.zzavs;
import com.google.android.gms.internal.ads.zzavt;
import com.google.android.gms.internal.ads.zzavu;
import com.google.android.gms.internal.ads.zzavv;
import com.google.android.gms.internal.ads.zzavw;
import com.google.android.gms.internal.ads.zzavx;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbjg;
import com.google.android.gms.internal.ads.zzyr;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzare
@ParametersAreNonnullByDefault
public final class zzavh {
    private final AtomicReference<ThreadPoolExecutor> zzdsf = new AtomicReference<Object>(null);
    private final Object zzdsg = new Object();
    @GuardedBy(value="gmpAppIdLock")
    @Nullable
    private String zzdsh = null;
    @GuardedBy(value="gmpAppIdLock")
    @Nullable
    private String zzdsi = null;
    @VisibleForTesting
    private final AtomicBoolean zzdsj = new AtomicBoolean(false);
    @VisibleForTesting
    private final AtomicInteger zzdsk = new AtomicInteger(-1);
    private final AtomicReference<Object> zzdsl = new AtomicReference<Object>(null);
    private final AtomicReference<Object> zzdsm = new AtomicReference<Object>(null);
    private final ConcurrentMap<String, Method> zzdsn = new ConcurrentHashMap<String, Method>(9);
    private final AtomicReference<zzbjg> zzdso = new AtomicReference<Object>(null);
    @GuardedBy(value="proxyReference")
    private final List<FutureTask> zzdsp = new ArrayList<FutureTask>();

    /*
     * Unable to fully structure code
     */
    public final boolean zzx(Context var1_1) {
        block4: {
            var2_2 = zzact.zzcnt;
            if (!((Boolean)zzyr.zzpe().zzd(var2_2)).booleanValue() || this.zzdsj.get()) {
                return false;
            }
            var2_2 = zzact.zzcod;
            if (((Boolean)zzyr.zzpe().zzd(var2_2)).booleanValue()) {
                return true;
            }
            if (this.zzdsk.get() != -1) break block4;
            zzyr.zzpa();
            var3_3 = var1_1;
            if (zzazu.zzc((Context)var3_3, (int)12451000)) ** GOTO lbl-1000
            zzyr.zzpa();
            if (zzazu.zzbg((Context)var1_1)) {
                zzaxa.zzep((String)"Google Play Service is out of date, the Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires updated Google Play Service.");
                this.zzdsk.set(0);
            } else lbl-1000:
            // 2 sources

            {
                this.zzdsk.set(1);
            }
        }
        return this.zzdsk.get() == 1;
    }

    @VisibleForTesting
    private static boolean zzy(Context context) {
        zzaci zzaci2 = zzact.zzcoa;
        if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            zzaci2 = zzact.zzcob;
            if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
                return false;
            }
        }
        zzaci2 = zzact.zzcoc;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            try {
                context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return true;
            }
        }
        return true;
    }

    public final void zzd(Context context, String string2) {
        if (!this.zzx(context)) {
            return;
        }
        if (zzavh.zzy(context)) {
            this.zza("beginAdUnitExposure", new zzavi(string2));
            return;
        }
        this.zza(context, string2, "beginAdUnitExposure");
    }

    public final void zze(Context context, String string2) {
        if (!this.zzx(context)) {
            return;
        }
        if (zzavh.zzy(context)) {
            this.zza("endAdUnitExposure", new zzavj(string2));
            return;
        }
        this.zza(context, string2, "endAdUnitExposure");
    }

    public final String zzz(Context context) {
        if (!this.zzx(context)) {
            return "";
        }
        if (zzavh.zzy(context)) {
            return this.zza("getCurrentScreenNameOrScreenClass", "", zzavn.zzdsv);
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsl, true)) {
            return "";
        }
        try {
            String string2 = (String)this.zzl(context, "getCurrentScreenName").invoke(this.zzdsl.get(), new Object[0]);
            if (string2 == null) {
                string2 = (String)this.zzl(context, "getCurrentScreenClass").invoke(this.zzdsl.get(), new Object[0]);
            }
            if (string2 != null) {
                return string2;
            }
            return "";
        }
        catch (Exception exception) {
            this.zza(exception, "getCurrentScreenName", false);
            return "";
        }
    }

    public final void zzf(Context context, String string2) {
        if (!this.zzx(context)) {
            return;
        }
        if (!(context instanceof Activity)) {
            return;
        }
        if (zzavh.zzy(context)) {
            this.zza("setScreenName", new zzavo(context, string2));
            return;
        }
        if (!this.zza(context, "com.google.firebase.analytics.FirebaseAnalytics", this.zzdsm, false)) {
            return;
        }
        Method method = this.zzm(context, "setCurrentScreen");
        try {
            Activity activity = (Activity)context;
            method.invoke(this.zzdsm.get(), activity, string2, context.getPackageName());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "setCurrentScreen", false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzaa(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        Object object = this.zzdsg;
        synchronized (object) {
            if (this.zzdsh != null) {
                return this.zzdsh;
            }
            this.zzdsh = zzavh.zzy(context) ? this.zza("getGmpAppId", this.zzdsh, zzavp.zzdsv) : (String)this.zza("getGmpAppId", context);
            return this.zzdsh;
        }
    }

    @Nullable
    public final String zzab(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        zzaci zzaci2 = zzact.zzcny;
        long l = (Long)zzyr.zzpe().zzd(zzaci2);
        if (zzavh.zzy(context)) {
            try {
                if (l < 0L) {
                    return (String)this.zza("getAppInstanceId", zzavq.zzdsv).get();
                }
                return (String)this.zza("getAppInstanceId", zzavr.zzdsv).get(l, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                if (exception instanceof TimeoutException) {
                    return "TIME_OUT";
                }
                return null;
            }
        }
        if (l < 0L) {
            return (String)this.zza("getAppInstanceId", context);
        }
        Future future = this.zzui().submit(new zzavs(this, context));
        try {
            return (String)future.get(l, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            future.cancel(true);
            if (exception instanceof TimeoutException) {
                return "TIME_OUT";
            }
            return null;
        }
    }

    @Nullable
    public final String zzac(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        if (zzavh.zzy(context)) {
            Long l = this.zza("getAdEventId", null, zzavt.zzdsv);
            if (l != null) {
                return Long.toString(l);
            }
            return null;
        }
        Object object = this.zza("generateEventId", context);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzad(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        Object object = this.zzdsg;
        synchronized (object) {
            if (this.zzdsi != null) {
                return this.zzdsi;
            }
            this.zzdsi = zzavh.zzy(context) ? this.zza("getAppIdOrigin", this.zzdsi, zzavu.zzdsv) : "fa";
            return this.zzdsi;
        }
    }

    public final void zzg(Context context, String string2) {
        this.zza(context, "_ac", string2, null);
    }

    public final void zzh(Context context, String string2) {
        this.zza(context, "_ai", string2, null);
    }

    public final void zzi(Context context, String string2) {
        this.zza(context, "_aq", string2, null);
    }

    public final void zzj(Context context, String string2) {
        this.zza(context, "_aa", string2, null);
    }

    public final void zza(Context context, String string2, String string3, String string4, int n) {
        if (!this.zzx(context)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string3);
        bundle.putString("type", string4);
        bundle.putInt("value", n);
        this.zza(context, "_ar", string2, bundle);
        zzaxa.zzds(new StringBuilder(75 + String.valueOf(string4).length()).append("Log a Firebase reward video event, reward type: ").append(string4).append(", reward value: ").append(n).toString());
    }

    private final void zza(Context context, String string2, String string3, @Nullable Bundle bundle) {
        if (!this.zzx(context)) {
            return;
        }
        Bundle bundle2 = zzavh.zzj(string3, string2);
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        if (zzavh.zzy(context)) {
            this.zza("logEventInternal", new zzavk(string2, bundle2));
            return;
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsl, true)) {
            return;
        }
        Method method = this.zzae(context);
        try {
            method.invoke(this.zzdsl.get(), "am", string2, bundle2);
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return;
        }
    }

    private static Bundle zzj(String string2, String string3) {
        Bundle bundle = new Bundle();
        try {
            bundle.putLong("_aeid", Long.parseLong(string2));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String string4 = String.valueOf(string2);
            zzaxa.zzc((String)(string4.length() != 0 ? "Invalid event ID: ".concat(string4) : new String("Invalid event ID: ")), (Throwable)runtimeException);
        }
        if ("_ac".equals(string3)) {
            bundle.putInt("_r", 1);
        }
        return bundle;
    }

    @Nullable
    private final Method zzae(Context context) {
        Method method = (Method)this.zzdsn.get("logEventInternal");
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod("logEventInternal", String.class, String.class, Bundle.class);
            this.zzdsn.put("logEventInternal", method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return null;
        }
    }

    @Nullable
    private final Method zzk(Context context, String string2) {
        Method method = (Method)this.zzdsn.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, String.class);
            this.zzdsn.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    @Nullable
    private final Method zzl(Context context, String string2) {
        Method method = (Method)this.zzdsn.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, new Class[0]);
            this.zzdsn.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final Method zzm(Context context, String string2) {
        Method method = (Method)this.zzdsn.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics").getDeclaredMethod(string2, Activity.class, String.class, String.class);
            this.zzdsn.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final void zza(Context context, String string2, String string3) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsl, true)) {
            return;
        }
        Method method = this.zzk(context, string3);
        try {
            method.invoke(this.zzdsl.get(), string2);
            zzaxa.zzds(new StringBuilder(37 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string3).append(", Ad Unit Id: ").append(string2).toString());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, string3, false);
            return;
        }
    }

    private final Object zza(String string2, Context context) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsl, true)) {
            return null;
        }
        Method method = this.zzl(context, string2);
        try {
            return method.invoke(this.zzdsl.get(), new Object[0]);
        }
        catch (Exception exception) {
            this.zza(exception, string2, true);
            return null;
        }
    }

    private final void zza(Exception exception, String string2, boolean bl) {
        if (!this.zzdsj.get()) {
            zzaxa.zzep((String)new StringBuilder(30 + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string2).append(" error.").toString());
            if (bl) {
                zzaxa.zzep((String)"The Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires the latest Firebase SDK jar, but Firebase SDK is either missing or out of date");
                this.zzdsj.set(true);
            }
        }
    }

    private final ThreadPoolExecutor zzui() {
        if (this.zzdsf.get() == null) {
            Object object = zzact.zzcnz;
            int n = (Integer)zzyr.zzpe().zzd(object);
            object = zzact.zzcnz;
            int n2 = (Integer)zzyr.zzpe().zzd(object);
            object = this;
            this.zzdsf.compareAndSet(null, new ThreadPoolExecutor(n, n2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new zzavv((zzavh)object)));
        }
        return this.zzdsf.get();
    }

    private final boolean zza(Context context, String string2, AtomicReference<Object> atomicReference, boolean bl) {
        if (atomicReference.get() == null) {
            try {
                Method method = context.getClassLoader().loadClass(string2).getDeclaredMethod("getInstance", Context.class);
                atomicReference.compareAndSet(null, method.invoke(null, context));
            }
            catch (Exception exception) {
                this.zza(exception, "getInstance", bl);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string2, zzavx zzavx2) {
        AtomicReference<zzbjg> atomicReference = this.zzdso;
        synchronized (atomicReference) {
            FutureTask<Object> futureTask = new FutureTask<Object>(new zzavl(this, zzavx2, string2), null);
            if (this.zzdso.get() != null) {
                futureTask.run();
            } else {
                this.zzdsp.add(futureTask);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> Future<T> zza(String string2, zzavw<T> zzavw2) {
        AtomicReference<zzbjg> atomicReference = this.zzdso;
        synchronized (atomicReference) {
            FutureTask futureTask = new FutureTask(new zzavm(this, zzavw2, string2));
            if (this.zzdso.get() != null) {
                this.zzui().submit(futureTask);
            } else {
                this.zzdsp.add(futureTask);
            }
            return futureTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T zza(String string2, @Nullable T t, zzavw<T> zzavw2) {
        AtomicReference<zzbjg> atomicReference = this.zzdso;
        synchronized (atomicReference) {
            if (this.zzdso.get() != null) {
                try {
                    return zzavw2.zzb(this.zzdso.get());
                }
                catch (Exception exception) {
                    this.zza(exception, string2, false);
                }
            }
            return t;
        }
    }

    final /* synthetic */ Object zza(zzavw zzavw2, String string2) throws Exception {
        try {
            return zzavw2.zzb(this.zzdso.get());
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            throw exception;
        }
    }

    final /* synthetic */ void zza(zzavx zzavx2, String string2) {
        if (this.zzdso.get() != null) {
            try {
                zzavx2.zza(this.zzdso.get());
                return;
            }
            catch (Exception exception) {
                this.zza(exception, string2, false);
            }
        }
    }

    final /* synthetic */ String zzaf(Context context) throws Exception {
        return (String)this.zza("getAppInstanceId", context);
    }
}

