/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzu;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzace;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzagt;
import com.google.android.gms.internal.ads.zzagu;
import com.google.android.gms.internal.ads.zzagv;
import com.google.android.gms.internal.ads.zzagw;
import com.google.android.gms.internal.ads.zzagy;
import com.google.android.gms.internal.ads.zzahn;
import com.google.android.gms.internal.ads.zzaho;
import com.google.android.gms.internal.ads.zzahp;
import com.google.android.gms.internal.ads.zzahq;
import com.google.android.gms.internal.ads.zzahr;
import com.google.android.gms.internal.ads.zzaps;
import com.google.android.gms.internal.ads.zzaqb;
import com.google.android.gms.internal.ads.zzaqd;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzavc;
import com.google.android.gms.internal.ads.zzavy;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzazy;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbgd;
import com.google.android.gms.internal.ads.zzbha;
import com.google.android.gms.internal.ads.zzbhc;
import com.google.android.gms.internal.ads.zzbhd;
import com.google.android.gms.internal.ads.zzbhe;
import com.google.android.gms.internal.ads.zzbhf;
import com.google.android.gms.internal.ads.zzbij;
import com.google.android.gms.internal.ads.zzbik;
import com.google.android.gms.internal.ads.zzbil;
import com.google.android.gms.internal.ads.zzbim;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzvq;
import com.google.android.gms.internal.ads.zzvt;
import com.google.android.gms.internal.ads.zzwh;
import com.google.android.gms.internal.ads.zzxp;
import com.google.android.gms.internal.ads.zzyr;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzare
@ParametersAreNonnullByDefault
@VisibleForTesting
public class zzbhb
extends WebViewClient
implements zzbij {
    private static final String[] zzejd = new String[]{"UNKNOWN", "HOST_LOOKUP", "UNSUPPORTED_AUTH_SCHEME", "AUTHENTICATION", "PROXY_AUTHENTICATION", "CONNECT", "IO", "TIMEOUT", "REDIRECT_LOOP", "UNSUPPORTED_SCHEME", "FAILED_SSL_HANDSHAKE", "BAD_URL", "FILE", "FILE_NOT_FOUND", "TOO_MANY_REQUESTS"};
    private static final String[] zzeje = new String[]{"NOT_YET_VALID", "EXPIRED", "ID_MISMATCH", "UNTRUSTED", "DATE_INVALID", "INVALID"};
    protected zzbha zzdjo;
    @Nullable
    private final zzwh zzejf;
    private final HashMap<String, List<zzahn<? super zzbha>>> zzejg = new HashMap();
    private final Object lock = new Object();
    private zzxp zzcgj;
    private zzo zzdko;
    private zzbik zzejh;
    private zzbil zzeji;
    private zzagu zzczo;
    private zzagw zzczp;
    private zzbim zzejj;
    private boolean zzejk = false;
    @GuardedBy(value="lock")
    private boolean zzbsz;
    @GuardedBy(value="lock")
    private boolean zzejl;
    @GuardedBy(value="lock")
    private boolean zzejm;
    private zzu zzdks;
    private final zzaqb zzejn;
    private zzb zzdaj;
    private zzaps zzdak;
    @Nullable
    protected zzavc zzejo;
    private boolean zzejp;
    private boolean zzejq;
    private int zzejr;
    private boolean zzdom;
    private View.OnAttachStateChangeListener zzejs;

    public zzbhb(zzbha zzbha2, zzwh zzwh2, boolean bl) {
        this(zzbha2, zzwh2, bl, new zzaqb(zzbha2, zzbha2.zzaad(), new zzace(zzbha2.getContext())), null);
    }

    @VisibleForTesting
    private zzbhb(zzbha zzbha2, zzwh zzwh2, boolean bl, zzaqb zzaqb2, zzaps zzaps2) {
        this.zzejf = zzwh2;
        this.zzdjo = zzbha2;
        this.zzbsz = bl;
        this.zzejn = zzaqb2;
        this.zzdak = null;
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzejn.zzj(n, n2);
        if (this.zzdak != null) {
            this.zzdak.zza(n, n2, false);
        }
    }

    @Override
    public final void zza(zzxp zzxp2, zzagu zzagu2, zzo zzo2, zzagw zzagw2, zzu zzu2, boolean bl, @Nullable zzaho zzaho2, zzb zzb2, zzaqd zzaqd2, @Nullable zzavc zzavc2) {
        boolean bl2;
        if (zzb2 == null) {
            zzb2 = new zzb(this.zzdjo.getContext(), zzavc2, null);
        }
        this.zzdak = new zzaps(this.zzdjo, zzaqd2);
        this.zzejo = zzavc2;
        zzaci zzaci2 = zzact.zzcow;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            this.zza("/adMetadata", new zzagt(zzagu2));
        }
        this.zza("/appEvent", new zzagv(zzagw2));
        this.zza("/backButton", zzagy.zzczz);
        this.zza("/refresh", zzagy.zzdaa);
        this.zza("/canOpenURLs", zzagy.zzczq);
        this.zza("/canOpenIntents", zzagy.zzczr);
        this.zza("/click", zzagy.zzczs);
        this.zza("/close", zzagy.zzczt);
        this.zza("/customClose", zzagy.zzczu);
        this.zza("/instrument", zzagy.zzdad);
        this.zza("/delayPageLoaded", zzagy.zzdaf);
        this.zza("/delayPageClosed", zzagy.zzdag);
        this.zza("/getLocationInfo", zzagy.zzdah);
        this.zza("/httpTrack", zzagy.zzczv);
        this.zza("/log", zzagy.zzczw);
        this.zza("/mraid", new zzahq(zzb2, this.zzdak, zzaqd2));
        this.zza("/mraidLoaded", this.zzejn);
        this.zza("/open", new zzahr(zzb2, this.zzdak));
        this.zza("/precache", new zzbgd());
        this.zza("/touch", zzagy.zzczy);
        this.zza("/video", zzagy.zzdab);
        this.zza("/videoMeta", zzagy.zzdac);
        if (zzk.zzme().zzx(this.zzdjo.getContext())) {
            this.zza("/logScionEvent", new zzahp(this.zzdjo.getContext()));
        }
        this.zzcgj = zzxp2;
        this.zzdko = zzo2;
        this.zzczo = zzagu2;
        this.zzczp = zzagw2;
        this.zzdks = zzu2;
        this.zzdaj = zzb2;
        this.zzejk = bl2 = bl;
    }

    @Override
    public final zzb zzaax() {
        return this.zzdaj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzaay() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzbsz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzaaz() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzejl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzaba() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzabb() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPageFinished(WebView webView, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdjo.isDestroyed()) {
                zzaxa.zzds("Blank page loaded, 1...");
                this.zzdjo.zzaao();
                return;
            }
        }
        this.zzejp = true;
        zzbhb zzbhb2 = this;
        if (zzbhb2.zzeji != null) {
            zzbhb2.zzeji.zzrw();
            zzbhb2.zzeji = null;
        }
        this.zzabh();
    }

    private final void zza(View view, zzavc zzavc2, int n) {
        if (zzavc2.zzud() && n > 0) {
            zzavc2.zzj(view);
            if (zzavc2.zzud()) {
                zzaxj.zzdvx.postDelayed((Runnable)new zzbhd(this, view, zzavc2, n), 100L);
            }
        }
    }

    private final void zzabc() {
        if (this.zzejs == null) {
            return;
        }
        this.zzdjo.getView().removeOnAttachStateChangeListener(this.zzejs);
    }

    @Override
    public final void zzabd() {
        zzavc zzavc2 = this.zzejo;
        if (zzavc2 != null) {
            WebView webView = this.zzdjo.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzavc2, 10);
                return;
            }
            zzavc zzavc3 = zzavc2;
            zzbhb zzbhb2 = this;
            zzbhb2.zzabc();
            zzbhb2.zzejs = new zzbhe(zzbhb2, zzavc3);
            zzbhb2.zzdjo.getView().addOnAttachStateChangeListener(zzbhb2.zzejs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzabe() {
        Object object = this.lock;
        synchronized (object) {
            this.zzejm = true;
        }
        ++this.zzejr;
        this.zzabh();
    }

    @Override
    public final void zzabf() {
        --this.zzejr;
        this.zzabh();
    }

    @Override
    public final void zzabg() {
        this.zzejq = true;
        this.zzabh();
    }

    private final void zzabh() {
        if (this.zzejh != null && (this.zzejp && this.zzejr <= 0 || this.zzejq)) {
            this.zzejh.zzae(!this.zzejq);
            this.zzejh = null;
        }
        this.zzdjo.zzaas();
    }

    public final void zza(zzc zzc2) {
        boolean bl = this.zzdjo.zzaan();
        this.zza(new AdOverlayInfoParcel(zzc2, (zzxp)(bl && !this.zzdjo.zzaag().zzabx() ? null : this.zzcgj), bl ? null : this.zzdko, this.zzdks, this.zzdjo.zzyh()));
    }

    public final void zzc(boolean bl, int n) {
        boolean bl2 = this.zzdjo.zzaan();
        this.zza(new AdOverlayInfoParcel((zzxp)(bl2 && !this.zzdjo.zzaag().zzabx() ? null : this.zzcgj), this.zzdko, this.zzdks, this.zzdjo, bl, n, this.zzdjo.zzyh()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzdjo.zzaan();
        this.zza(new AdOverlayInfoParcel((zzxp)(bl2 && !this.zzdjo.zzaag().zzabx() ? null : this.zzcgj), bl2 ? null : new zzbhf(this.zzdjo, this.zzdko), this.zzczo, this.zzczp, this.zzdks, this.zzdjo, bl, n, string2, this.zzdjo.zzyh()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzdjo.zzaan();
        this.zza(new AdOverlayInfoParcel((zzxp)(bl2 && !this.zzdjo.zzaag().zzabx() ? null : this.zzcgj), bl2 ? null : new zzbhf(this.zzdjo, this.zzdko), this.zzczo, this.zzczp, this.zzdks, this.zzdjo, bl, n, string2, string3, this.zzdjo.zzyh()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzdak != null) {
            bl = this.zzdak.zztb();
        }
        zzk.zzlf();
        zzm.zza(this.zzdjo.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzejo != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzdkn != null) {
                string2 = adOverlayInfoParcel.zzdkn.url;
            }
            this.zzejo.zzdk(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, zzahn<? super zzbha> zzahn2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzahn<? super zzbha>> list = this.zzejg.get(string2);
            if (list == null) {
                list = new CopyOnWriteArrayList<zzahn<? super zzbha>>();
                this.zzejg.put(string2, list);
            }
            list.add(zzahn2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(String string2, zzahn<? super zzbha> zzahn2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzahn<? super zzbha>> list = this.zzejg.get(string2);
            if (list == null) {
                return;
            }
            list.remove(zzahn2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, Predicate<zzahn<? super zzbha>> predicate) {
        Object object = this.lock;
        synchronized (object) {
            List<zzahn<? super zzbha>> list = this.zzejg.get(string2);
            if (list == null) {
                return;
            }
            ArrayList<zzahn<? super zzbha>> arrayList = new ArrayList<zzahn<? super zzbha>>();
            for (zzahn<? super zzbha> zzahn2 : list) {
                if (!predicate.apply(zzahn2)) continue;
                arrayList.add(zzahn2);
            }
            list.removeAll(arrayList);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        if (this.zzejo != null) {
            this.zzejo.zzuf();
            this.zzejo = null;
        }
        this.zzabc();
        Object object = this.lock;
        synchronized (object) {
            this.zzejg.clear();
            this.zzcgj = null;
            this.zzdko = null;
            this.zzejh = null;
            this.zzeji = null;
            this.zzczo = null;
            this.zzczp = null;
            this.zzejk = false;
            this.zzbsz = false;
            this.zzejl = false;
            this.zzejm = false;
            this.zzdks = null;
            this.zzejj = null;
            if (this.zzdak != null) {
                this.zzdak.zzw(true);
                this.zzdak = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzbik zzbik2) {
        this.zzejh = zzbik2;
    }

    @Override
    public final void zza(zzbil zzbil2) {
        this.zzeji = zzbil2;
    }

    public final void onLoadResource(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzaxa.zzds(string3.length() != 0 ? "Loading resource: ".concat(string3) : new String("Loading resource: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        }
    }

    public final void onReceivedError(WebView webView, int n, String string2, String string3) {
        String string4 = n < 0 && -n - 1 < zzejd.length ? zzejd[-n - 1] : String.valueOf(n);
        this.zze(this.zzdjo.getContext(), "http_err", string4, string3);
        super.onReceivedError(webView, n, string2, string3);
    }

    public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        if (sslError != null) {
            int n = sslError.getPrimaryError();
            String string2 = n >= 0 && n < zzeje.length ? zzeje[n] : String.valueOf(n);
            Context context = this.zzdjo.getContext();
            zzk.zzli();
            this.zze(context, "ssl_err", string2, sslError.getUrl());
        }
        super.onReceivedSslError(webView, sslErrorHandler, sslError);
    }

    private final void zze(Context context, String string2, String string3, String string4) {
        Uri uri;
        Object object = zzact.zzcqp;
        if (!((Boolean)zzyr.zzpe().zzd(object)).booleanValue()) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("err", string2);
        bundle.putString("code", string3);
        object = string4;
        bundle.putString("host", !TextUtils.isEmpty((CharSequence)object) && (uri = Uri.parse((String)object)).getHost() != null ? uri.getHost() : "");
        zzk.zzlg().zza(context, this.zzdjo.zzyh().zzbsy, "gmob-apps", bundle, true);
    }

    public final boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzaxa.zzds(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        } else {
            String string4;
            if (this.zzejk && webView == this.zzdjo.getWebView() && ("http".equalsIgnoreCase(string4 = uri.getScheme()) || "https".equalsIgnoreCase(string4))) {
                if (this.zzcgj != null) {
                    this.zzcgj.onAdClicked();
                    if (this.zzejo != null) {
                        this.zzejo.zzdk(string2);
                    }
                    this.zzcgj = null;
                }
                return super.shouldOverrideUrlLoading(webView, string2);
            }
            if (!this.zzdjo.getWebView().willNotDraw()) {
                try {
                    zzdh zzdh2 = this.zzdjo.zzaal();
                    if (zzdh2 != null && zzdh2.zzc(uri)) {
                        uri = zzdh2.zza(uri, this.zzdjo.getContext(), this.zzdjo.getView(), this.zzdjo.zzyd());
                    }
                }
                catch (zzdi zzdi2) {
                    String string5 = String.valueOf(string2);
                    zzaxa.zzep((String)(string5.length() != 0 ? "Unable to append parameter to URL: ".concat(string5) : new String("Unable to append parameter to URL: ")));
                }
                if (this.zzdaj == null || this.zzdaj.zzkx()) {
                    this.zza(new zzc("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
                } else {
                    this.zzdaj.zzbk(string2);
                }
            } else {
                String string6 = String.valueOf(string2);
                zzaxa.zzep((String)(string6.length() != 0 ? "AdWebView unable to handle URL: ".concat(string6) : new String("AdWebView unable to handle URL: ")));
            }
        }
        return true;
    }

    @TargetApi(value=11)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        return this.zzd(string2, Collections.emptyMap());
    }

    @Nullable
    protected final WebResourceResponse zzd(String string2, Map<String, String> map) {
        try {
            zzvq zzvq2;
            String string3 = zzavy.zzd(string2, this.zzdjo.getContext(), this.zzdom);
            if (!string3.equals(string2)) {
                return this.zze(string3, map);
            }
            zzvt zzvt2 = zzvt.zzbo(string2);
            if (zzvt2 != null && (zzvq2 = zzk.zzlm().zza(zzvt2)) != null && zzvq2.zznh()) {
                return new WebResourceResponse("", "", zzvq2.zzni());
            }
            if (zzazy.isEnabled()) {
                zzaci zzaci2 = zzact.zzcqd;
                if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
                    return this.zze(string2, map);
                }
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            zzk.zzlk().zza(throwable, "AdWebViewClient.interceptRequest");
            return zzbhb.zzabi();
        }
    }

    private static WebResourceResponse zzabi() {
        zzaci zzaci2 = zzact.zzcon;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    private final WebResourceResponse zze(String string2, Map<String, String> map) throws IOException {
        URL uRL = new URL(string2);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            zzk.zzlg().zza(this.zzdjo.getContext(), this.zzdjo.zzyh().zzbsy, false, httpURLConnection);
            zzazy zzazy22 = new zzazy();
            zzazy22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzazy22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string3 = httpURLConnection.getHeaderField("Location");
                if (string3 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                String string4 = (uRL = new URL(uRL, string3)).getProtocol();
                if (string4 == null) {
                    zzaxa.zzep((String)"Protocol is null");
                    return zzbhb.zzabi();
                }
                if (!string4.equals("http") && !string4.equals("https")) {
                    String string5 = String.valueOf(string4);
                    zzaxa.zzep((String)(string5.length() != 0 ? "Unsupported scheme: ".concat(string5) : new String("Unsupported scheme: ")));
                    return zzbhb.zzabi();
                }
                String string6 = String.valueOf(string3);
                zzaxa.zzdp((String)(string6.length() != 0 ? "Redirecting to ".concat(string6) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            zzk.zzlg();
            return zzaxj.zzd(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzao(boolean bl) {
        this.zzejk = bl;
    }

    @Override
    public final zzavc zzabj() {
        return this.zzejo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzth() {
        Object object = this.lock;
        synchronized (object) {
            this.zzejk = false;
            this.zzbsz = true;
            zzbbn.zzeag.execute(new zzbhc(this));
            return;
        }
    }

    public final void zzat(boolean bl) {
        this.zzdom = bl;
    }

    @Override
    public final void zzi(int n, int n2) {
        if (this.zzdak != null) {
            this.zzdak.zzi(n, n2);
        }
    }

    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void zzh(Uri uri) {
        String string2 = uri.getPath();
        List<zzahn<? super zzbha>> list = this.zzejg.get(string2);
        if (list != null) {
            zzk.zzlg();
            Map<String, String> map = zzaxj.zzi(uri);
            if (zzaxa.isLoggable((int)2)) {
                String string3 = String.valueOf(string2);
                zzaxa.zzds(string3.length() != 0 ? "Received GMSG: ".concat(string3) : new String("Received GMSG: "));
                for (String string4 : map.keySet()) {
                    String string5 = map.get(string4);
                    zzaxa.zzds(new StringBuilder(4 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("  ").append(string4).append(": ").append(string5).toString());
                }
            }
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza(this.zzdjo, map);
            }
            return;
        }
        String string6 = String.valueOf(uri);
        zzaxa.zzds(new StringBuilder(32 + String.valueOf(string6).length()).append("No GMSG handler found for GMSG: ").append(string6).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzau(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzejl = true;
            return;
        }
    }

    @TargetApi(value=26)
    public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        return this.zzdjo.zzb(renderProcessGoneDetail.didCrash(), renderProcessGoneDetail.rendererPriorityAtExit());
    }

    static /* synthetic */ void zza(zzbhb zzbhb2, View view, zzavc zzavc2, int n) {
        zzbhb2.zza(view, zzavc2, n);
    }
}

