/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdnh;
import com.google.android.gms.internal.ads.zzdpj;
import com.google.android.gms.internal.ads.zzdrp;
import com.google.android.gms.internal.ads.zzdrv;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzdro {
    private final ByteBuffer zzaxl;
    private zzdnh zzhnm;
    private int zzhnn;

    private zzdro(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzdro(ByteBuffer byteBuffer) {
        this.zzaxl = byteBuffer;
        this.zzaxl.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzdro zzaf(byte[] byArray) {
        return zzdro.zzp(byArray, 0, byArray.length);
    }

    public static zzdro zzp(byte[] byArray, int n, int n2) {
        return new zzdro(byArray, 0, n2);
    }

    public final void zzx(int n, int n2) throws IOException {
        this.zzw(n, 0);
        int n3 = n2;
        zzdro zzdro2 = this;
        if (n3 >= 0) {
            zzdro2.zzhe(n3);
            return;
        }
        zzdro2.zzfv(n3);
    }

    public final void zzi(int n, boolean bl) throws IOException {
        this.zzw(3, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzdro zzdro2 = this;
        if (!zzdro2.zzaxl.hasRemaining()) {
            throw new zzdrp(zzdro2.zzaxl.position(), zzdro2.zzaxl.limit());
        }
        zzdro2.zzaxl.put(by);
    }

    public final void zzf(int n, String string2) throws IOException {
        this.zzw(n, 2);
        String string3 = string2;
        zzdro zzdro2 = this;
        try {
            int n2 = zzdro.zzgl(string3.length());
            int n3 = zzdro.zzgl(string3.length() * 3);
            if (n2 == n3) {
                int n4 = zzdro2.zzaxl.position();
                if (zzdro2.zzaxl.remaining() < n2) {
                    throw new zzdrp(n4 + n2, zzdro2.zzaxl.limit());
                }
                zzdro2.zzaxl.position(n4 + n2);
                zzdro.zzd(string3, zzdro2.zzaxl);
                int n5 = zzdro2.zzaxl.position();
                zzdro2.zzaxl.position(n4);
                zzdro2.zzhe(n5 - n4 - n2);
                zzdro2.zzaxl.position(n5);
                return;
            }
            zzdro2.zzhe(zzdro.zza(string3));
            zzdro.zzd(string3, zzdro2.zzaxl);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzdrp zzdrp2 = new zzdrp(zzdro2.zzaxl.position(), zzdro2.zzaxl.limit());
            zzdrp2.initCause(bufferOverflowException);
            throw zzdrp2;
        }
    }

    public final void zza(int n, zzdrv zzdrv2) throws IOException {
        this.zzw(n, 2);
        zzdrv zzdrv3 = zzdrv2;
        zzdro zzdro2 = this;
        zzdrv zzdrv4 = zzdrv3;
        if (zzdrv4.zzhnx < 0) {
            zzdrv4.zzaxj();
        }
        zzdro2.zzhe(zzdrv4.zzhnx);
        zzdrv3.zza(zzdro2);
    }

    public final void zze(int n, zzdpj zzdpj2) throws IOException {
        zzdro zzdro2 = this;
        if (zzdro2.zzhnm == null) {
            zzdro2.zzhnm = zzdnh.zzm((ByteBuffer)zzdro2.zzaxl);
            zzdro2.zzhnn = zzdro2.zzaxl.position();
        } else if (zzdro2.zzhnn != zzdro2.zzaxl.position()) {
            zzdro2.zzhnm.write(zzdro2.zzaxl.array(), zzdro2.zzhnn, zzdro2.zzaxl.position() - zzdro2.zzhnn);
            zzdro2.zzhnn = zzdro2.zzaxl.position();
        }
        zzdnh zzdnh2 = zzdro2.zzhnm;
        zzdnh2.zza(n, zzdpj2);
        zzdnh2.flush();
        this.zzhnn = this.zzaxl.position();
    }

    public final void zza(int n, byte[] byArray) throws IOException {
        this.zzw(n, 2);
        byte[] byArray2 = byArray;
        zzdro zzdro2 = this;
        zzdro2.zzhe(byArray2.length);
        byte[] byArray3 = byArray2;
        int n2 = byArray3.length;
        byte[] byArray4 = byArray2;
        zzdro zzdro3 = zzdro2;
        if (zzdro3.zzaxl.remaining() >= n2) {
            zzdro3.zzaxl.put(byArray4, 0, n2);
            return;
        }
        throw new zzdrp(zzdro3.zzaxl.position(), zzdro3.zzaxl.limit());
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zzd(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zzab(int n, int n2) {
        return zzdro.zzgd(n) + zzdro.zzge(n2);
    }

    public static int zzg(int n, String string2) {
        return zzdro.zzgd(n) + zzdro.zzgx(string2);
    }

    public static int zzb(int n, zzdrv zzdrv2) {
        int n2 = zzdrv2.zzaxj();
        return zzdro.zzgd(n) + (zzdro.zzgl(n2) + n2);
    }

    public static int zzb(int n, byte[] byArray) {
        byte[] byArray2 = byArray;
        return zzdro.zzgd(n) + (zzdro.zzgl(byArray.length) + byArray2.length);
    }

    public static int zzge(int n) {
        if (n >= 0) {
            return zzdro.zzgl(n);
        }
        return 10;
    }

    public static int zzgx(String string2) {
        int n = zzdro.zza(string2);
        return zzdro.zzgl(n) + n;
    }

    public final void zzawv() {
        if (this.zzaxl.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzaxl.remaining()));
        }
    }

    private final void zzhd(int n) throws IOException {
        byte by = (byte)n;
        zzdro zzdro2 = this;
        if (!zzdro2.zzaxl.hasRemaining()) {
            throw new zzdrp(zzdro2.zzaxl.position(), zzdro2.zzaxl.limit());
        }
        zzdro2.zzaxl.put(by);
    }

    public final void zzw(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzhe(n << 3 | n3);
    }

    public static int zzgd(int n) {
        return zzdro.zzgl(n << 3);
    }

    private final void zzhe(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzhd(n);
                return;
            }
            this.zzhd(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    private static int zzgl(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public final void zzfv(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzhd((int)l);
                return;
            }
            this.zzhd((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzfw(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }
}

