/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzbp;
import com.google.android.gms.internal.ads.zzci;
import com.google.android.gms.internal.ads.zzda;
import com.google.android.gms.internal.ads.zzdak;
import com.google.android.gms.internal.ads.zzdj;
import com.google.android.gms.internal.ads.zzdk;
import com.google.android.gms.internal.ads.zzdmq;
import com.google.android.gms.internal.ads.zzdnn;
import com.google.android.gms.internal.ads.zzdoa;
import com.google.android.gms.internal.ads.zzdv;
import com.google.android.gms.internal.ads.zzdz;
import com.google.android.gms.internal.ads.zzea;
import com.google.android.gms.internal.ads.zzeb;
import com.google.android.gms.internal.ads.zzec;
import com.google.android.gms.internal.ads.zzef;
import com.google.android.gms.internal.ads.zzfi;
import com.google.android.gms.internal.ads.zzyr;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdy {
    private static final String TAG = zzdy.class.getSimpleName();
    protected Context zzlj;
    private ExecutorService zzxf;
    private DexClassLoader zzxg;
    private zzdj zzxh;
    private byte[] zzxi;
    private volatile AdvertisingIdClient zzxj = null;
    private volatile boolean zzwf = false;
    private Future zzxk = null;
    private boolean zzxl;
    private volatile zzbp.zza zzxm = null;
    private Future zzxn = null;
    private zzda zzxo;
    protected boolean zzxp = false;
    private boolean zzxq = false;
    private Map<Pair<String, String>, zzfi> zzxr;
    private boolean zzxs = false;
    private boolean zzxt = true;
    private boolean zzxu = false;

    public static zzdy zza(Context context, String string2, String string3, boolean bl) {
        zzdy zzdy2 = new zzdy(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdy zzdy3 = zzdy2;
            zzdy2.zzxf = Executors.newCachedThreadPool(new zzdz());
            boolean bl3 = bl2;
            zzdy zzdy4 = zzdy3;
            zzdy3.zzwf = bl3;
            if (bl3) {
                zzdy4.zzxk = zzdy4.zzxf.submit(new zzea(zzdy4));
            }
            zzdy zzdy5 = zzdy3;
            zzdy5.zzxf.execute(new zzec(zzdy5));
            try {
                object = GoogleApiAvailabilityLight.getInstance();
                zzdy5.zzxp = object.getApkVersion(zzdy5.zzlj) > 0;
                zzdy5.zzxq = object.isGooglePlayServicesAvailable(zzdy5.zzlj) == 0;
            }
            catch (Throwable throwable) {}
            zzdy3.zza(0, true);
            if (zzef.isMainThread()) {
                zzdy4 = zzact.zzcro;
                if (((Boolean)zzyr.zzpe().zzd((zzaci)zzdy4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzdy5 = zzdy3;
            zzdy3.zzxh = new zzdj(null);
            try {
                zzdy5.zzxi = zzdy5.zzxh.zzan((String)object);
            }
            catch (zzdk zzdk2) {
                throw new zzdv(zzdk2);
            }
            object = string4;
            zzdy5 = zzdy3;
            try {
                String string6;
                File file = zzdy5.zzlj.getCacheDir();
                if (file == null && (file = zzdy5.zzlj.getDir("dex", 0)) == null) {
                    throw new zzdv();
                }
                String string7 = string6 = "1542658731108";
                File file2 = file;
                Object object2 = object;
                zzdy zzdy6 = zzdy5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzdy6.zzxh.zza(zzdy6.zzxi, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdy5.zzb(file, string6);
                try {
                    zzdy5.zzxg = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdy5.zzlj.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdy.zzb(file4);
                    zzdy5.zza(file, string6);
                    zzdy.zzao(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzdy.zzb(file4);
                zzdy5.zza(file, string6);
                zzdy.zzao(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzdv(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzdv(iOException);
            }
            catch (zzdk zzdk3) {
                throw new zzdv(zzdk3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzdv(nullPointerException);
            }
            zzdy4 = zzdy3;
            if (!zzdy4.zzxu) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                zzdy4.zzlj.registerReceiver((BroadcastReceiver)zzdy4.new zza(null), intentFilter);
                zzdy4.zzxu = true;
            }
            zzdy3.zzxo = new zzda(zzdy3);
            zzdy3.zzxs = true;
        }
        catch (zzdv zzdv2) {}
        return zzdy2;
    }

    public final Context getContext() {
        return this.zzlj;
    }

    public final boolean isInitialized() {
        return this.zzxs;
    }

    public final ExecutorService zzch() {
        return this.zzxf;
    }

    public final DexClassLoader zzci() {
        return this.zzxg;
    }

    public final zzdj zzcj() {
        return this.zzxh;
    }

    public final byte[] zzck() {
        return this.zzxi;
    }

    public final boolean zzcl() {
        return this.zzxp;
    }

    public final zzda zzcm() {
        return this.zzxo;
    }

    public final boolean zzcn() {
        return this.zzxq;
    }

    public final boolean zzco() {
        return this.zzxt;
    }

    public final zzbp.zza zzcp() {
        return this.zzxm;
    }

    public final Future zzcq() {
        return this.zzxn;
    }

    private zzdy(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzxl = context2 != null;
        this.zzlj = this.zzxl ? context2 : context;
        this.zzxr = new HashMap<Pair<String, String>, zzfi>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdy.zzb(file2);
            return;
        }
        System.out.print("test");
        System.out.print("test");
        System.out.print("test");
        zzbp.zzd.zza zza2 = zzbp.zzd.zzbc().zzl(zzdmq.zzz((byte[])Build.VERSION.SDK.getBytes())).zzk(zzdmq.zzz((byte[])string2.getBytes()));
        byte[] byArray2 = this.zzxh.zzb(this.zzxi, byArray).getBytes();
        zza2.zzi(zzdmq.zzz((byte[])byArray2)).zzj(zzdmq.zzz((byte[])zzci.zzb(byArray2)));
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = ((zzbp.zzd)((zzdoa)zza2.zzaya())).toByteArray();
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdy.zzb(file2);
        return;
        catch (zzdk | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdy.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdy.zzb(file2);
            throw throwable;
        }
    }

    private static void zzao(String string2) {
        zzdy.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbp.zzd zzd2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdy.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdy.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                zzd2 = zzbp.zzd.zzc((byte[])byArray, (zzdnn)zzdnn.zzaxe());
                if (string2.equals(new String(zzd2.zzba().toByteArray())) && Arrays.equals(zzd2.zzaz().toByteArray(), zzci.zzb(zzd2.zzay().toByteArray())) && Arrays.equals(zzd2.zzbb().toByteArray(), Build.VERSION.SDK.getBytes())) break block30;
                zzdy.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzxh.zza(this.zzxi, new String(zzd2.zzay().toByteArray()));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzdk | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzxr.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzxr.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzfi(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zzc(String string2, String string3) {
        zzfi zzfi2 = this.zzxr.get(new Pair((Object)string2, (Object)string3));
        if (zzfi2 == null) {
            return null;
        }
        return zzfi2.zzdc();
    }

    private final void zzcr() {
        try {
            if (this.zzxj == null && this.zzxl) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzlj);
                advertisingIdClient.start();
                this.zzxj = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzxj = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzxq) {
            return;
        }
        Future<?> future = this.zzxf.submit(new zzeb(this, n, bl));
        if (n == 0) {
            this.zzxn = future;
        }
    }

    @VisibleForTesting
    final zzbp.zza zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzcs();
    }

    private static boolean zza(int n, zzbp.zza zza2) {
        if (n < 4) {
            if (zza2 == null) {
                return true;
            }
            if (!zza2.zzai() || zza2.zzae().equals("0000000000000000000000000000000000000000000000000000000000000000")) {
                return true;
            }
            if (!zza2.zzak() || !zza2.zzal().zzbe() || zza2.zzal().zzbf() == -2L) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzbp.zza zzcs() {
        zzbp.zza zza2 = null;
        try {
            PackageInfo packageInfo = this.zzlj.getPackageManager().getPackageInfo(this.zzlj.getPackageName(), 0);
            zza2 = zzdak.zzj((Context)this.zzlj, (String)this.zzlj.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zza2;
    }

    public final AdvertisingIdClient zzct() {
        if (!this.zzwf) {
            return null;
        }
        if (this.zzxj != null) {
            return this.zzxj;
        }
        if (this.zzxk != null) {
            try {
                this.zzxk.get(2000L, TimeUnit.MILLISECONDS);
                this.zzxk = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzxk.cancel(true);
            }
        }
        return this.zzxj;
    }

    public final int zzcd() {
        int n = Integer.MIN_VALUE;
        if (this.zzxo != null) {
            n = zzda.zzcd();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdy zzdy2) {
        zzdy2.zzcr();
    }

    static /* synthetic */ zzbp.zza zza(zzdy zzdy2, zzbp.zza zza2) {
        zzdy2.zzxm = zza2;
        return zzdy2.zzxm;
    }

    static /* synthetic */ boolean zzb(int n, zzbp.zza zza2) {
        return zzdy.zza(n, zza2);
    }

    final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzdy.this.zzxt = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzdy.this.zzxt = false;
            }
        }

        /* synthetic */ zza(zzdz zzdz2) {
            this();
        }
    }
}

