/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.media.AudioTrack;
import android.media.MediaFormat;
import android.os.ConditionVariable;
import android.util.Log;
import com.google.android.gms.internal.ads.zzhr;
import com.google.android.gms.internal.ads.zzhs;
import com.google.android.gms.internal.ads.zzht;
import com.google.android.gms.internal.ads.zzhu;
import com.google.android.gms.internal.ads.zzhv;
import com.google.android.gms.internal.ads.zzkg;
import com.google.android.gms.internal.ads.zzkh;
import com.google.android.gms.internal.ads.zzkl;
import com.google.android.gms.internal.ads.zzkq;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class zzhq {
    private static boolean zzagc = false;
    private final ConditionVariable zzagd = new ConditionVariable(true);
    private final long[] zzage;
    private final zzhs zzagf;
    private AudioTrack zzagg;
    private int zzafv;
    private int zzagh;
    private int zzagi;
    private int zzagj;
    private int zzagk;
    private int zzagl;
    private int zzagm;
    private int zzagn;
    private long zzago;
    private long zzagp;
    private boolean zzagq;
    private long zzagr;
    private Method zzags;
    private long zzagt;
    private int zzagu;
    private long zzagv;
    private long zzagw;
    private long zzagx;
    private float zzcv;
    private byte[] zzagy;
    private int zzagz;
    private int zzaha;
    private boolean zzahb;
    private int zzahc;

    public zzhq() {
        if (zzkq.SDK_INT >= 18) {
            try {
                this.zzags = AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.zzagf = zzkq.SDK_INT >= 19 ? new zzht() : new zzhs(null);
        this.zzage = new long[10];
        this.zzcv = 1.0f;
        this.zzagu = 0;
    }

    public final boolean isInitialized() {
        return this.zzagg != null;
    }

    public final long zzf(boolean bl) {
        long l;
        zzhq zzhq2 = this;
        if (!(zzhq2.isInitialized() && zzhq2.zzagv != 0L)) {
            return Long.MIN_VALUE;
        }
        if (this.zzagg.getPlayState() == 3) {
            zzhq2 = this;
            long l2 = zzhq2.zzagf.zzew();
            if (l2 != 0L) {
                long l3 = System.nanoTime() / 1000L;
                if (l3 - zzhq2.zzagp >= 30000L) {
                    zzhq2.zzage[zzhq2.zzagm] = l2 - l3;
                    zzhq2.zzagm = (zzhq2.zzagm + 1) % 10;
                    if (zzhq2.zzagn < 10) {
                        ++zzhq2.zzagn;
                    }
                    zzhq2.zzagp = l3;
                    zzhq2.zzago = 0L;
                    for (int i = 0; i < zzhq2.zzagn; ++i) {
                        zzhq2.zzago += zzhq2.zzage[i] / (long)zzhq2.zzagn;
                    }
                }
                if (!zzhq2.zzahb && l3 - zzhq2.zzagr >= 500000L) {
                    zzhq2.zzagq = zzhq2.zzagf.zzex();
                    if (zzhq2.zzagq) {
                        long l4 = zzhq2.zzagf.zzey() / 1000L;
                        long l5 = zzhq2.zzagf.zzez();
                        if (l4 < zzhq2.zzagw) {
                            zzhq2.zzagq = false;
                        } else if (Math.abs(l4 - l3) > 5000000L) {
                            zzhq2.zzagq = false;
                            Log.w((String)"AudioTrack", (String)new StringBuilder(136).append("Spurious audio timestamp (system clock mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString());
                        } else if (Math.abs(zzhq2.zzdo(l5) - l2) > 5000000L) {
                            zzhq2.zzagq = false;
                            Log.w((String)"AudioTrack", (String)new StringBuilder(138).append("Spurious audio timestamp (frame position mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString());
                        }
                    }
                    if (zzhq2.zzags != null) {
                        try {
                            zzhq2.zzagx = (long)((Integer)zzhq2.zzags.invoke((Object)zzhq2.zzagg, null)).intValue() * 1000L - zzhq2.zzdo(zzhq2.zzdn(zzhq2.zzagl));
                            zzhq2.zzagx = Math.max(zzhq2.zzagx, 0L);
                            if (zzhq2.zzagx > 5000000L) {
                                long l6 = zzhq2.zzagx;
                                Log.w((String)"AudioTrack", (String)new StringBuilder(61).append("Ignoring impossibly large audio latency: ").append(l6).toString());
                                zzhq2.zzagx = 0L;
                            }
                        }
                        catch (Exception exception) {
                            zzhq2.zzags = null;
                        }
                    }
                    zzhq2.zzagr = l3;
                }
            }
        }
        long l7 = System.nanoTime() / 1000L;
        if (this.zzagq) {
            long l8 = l7 - this.zzagf.zzey() / 1000L;
            long l9 = this.zzdp(l8);
            long l10 = this.zzagf.zzez() + l9;
            l = this.zzdo(l10) + this.zzagv;
        } else {
            l = this.zzagn == 0 ? this.zzagf.zzew() + this.zzagv : l7 + this.zzago + this.zzagv;
            if (!bl) {
                l -= this.zzagx;
            }
        }
        return l;
    }

    public final int zzq(int n) throws zzhu {
        this.zzagd.block();
        this.zzagg = n == 0 ? new AudioTrack(3, this.zzafv, this.zzagh, this.zzagi, this.zzagl, 1) : new AudioTrack(3, this.zzafv, this.zzagh, this.zzagi, this.zzagl, 1, n);
        zzhq zzhq2 = this;
        int n2 = zzhq2.zzagg.getState();
        if (n2 != 1) {
            try {
                zzhq2.zzagg.release();
            }
            catch (Exception exception) {
            }
            finally {
                zzhq2.zzagg = null;
            }
            throw new zzhu(n2, zzhq2.zzafv, zzhq2.zzagh, zzhq2.zzagl);
        }
        n = this.zzagg.getAudioSessionId();
        this.zzagf.zza(this.zzagg, this.zzahb);
        this.setVolume(this.zzcv);
        return n;
    }

    public final void zza(MediaFormat mediaFormat, int n) {
        boolean bl;
        int n2;
        int n3 = mediaFormat.getInteger("channel-count");
        switch (n3) {
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 6: {
                n2 = 252;
                break;
            }
            case 8: {
                n2 = 1020;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(38).append("Unsupported channel count: ").append(n3).toString());
            }
        }
        int n4 = mediaFormat.getInteger("sample-rate");
        String string2 = mediaFormat.getString("mime");
        int n5 = "audio/ac3".equals(string2) ? 5 : ("audio/eac3".equals(string2) ? 6 : (zzkl.zzav(string2) ? 2 : 0));
        boolean bl2 = bl = n5 == 5 || n5 == 6;
        if (this.isInitialized() && this.zzafv == n4 && this.zzagh == n2 && !this.zzahb && !bl) {
            return;
        }
        this.reset();
        this.zzagi = n5;
        this.zzafv = n4;
        this.zzagh = n2;
        this.zzahb = bl;
        this.zzahc = 0;
        this.zzagj = 2 * n3;
        this.zzagk = AudioTrack.getMinBufferSize((int)n4, (int)n2, (int)n5);
        zzkh.checkState(this.zzagk != -2);
        int n6 = this.zzagk << 2;
        int n7 = (int)this.zzdp(250000L) * this.zzagj;
        int n8 = (int)Math.max((long)this.zzagk, this.zzdp(750000L) * (long)this.zzagj);
        this.zzagl = n6 < n7 ? n7 : (n6 > n8 ? n8 : n6);
    }

    public final void play() {
        if (this.isInitialized()) {
            this.zzagw = System.nanoTime() / 1000L;
            this.zzagg.play();
        }
    }

    public final void zzeq() {
        if (this.zzagu == 1) {
            this.zzagu = 2;
        }
    }

    public final int zza(ByteBuffer byteBuffer, int n, int n2, long l) throws zzhv {
        if (n2 == 0) {
            return 2;
        }
        if (zzkq.SDK_INT <= 22 && this.zzahb) {
            if (this.zzagg.getPlayState() == 2) {
                return 0;
            }
            if (this.zzagg.getPlayState() == 1 && this.zzagf.zzev() != 0L) {
                return 0;
            }
        }
        int n3 = 0;
        if (this.zzaha == 0) {
            if (this.zzahb && this.zzahc == 0) {
                this.zzahc = zzkg.zza(n2, this.zzafv);
            }
            long l2 = l - this.zzdo(this.zzdn(n2));
            if (this.zzagv == 0L) {
                this.zzagv = Math.max(0L, l2);
                this.zzagu = 1;
            } else {
                long l3 = this.zzagv + this.zzdo(this.zzdn(this.zzagt));
                if (this.zzagu == 1 && Math.abs(l3 - l2) > 200000L) {
                    Log.e((String)"AudioTrack", (String)new StringBuilder(80).append("Discontinuity detected [expected ").append(l3).append(", got ").append(l2).append("]").toString());
                    this.zzagu = 2;
                }
                if (this.zzagu == 2) {
                    this.zzagv += l2 - l3;
                    this.zzagu = 1;
                    n3 = 1;
                }
            }
        }
        if (this.zzaha == 0) {
            this.zzaha = n2;
            byteBuffer.position(n);
            if (zzkq.SDK_INT < 21) {
                if (this.zzagy == null || this.zzagy.length < n2) {
                    this.zzagy = new byte[n2];
                }
                byteBuffer.get(this.zzagy, 0, n2);
                this.zzagz = 0;
            }
        }
        int n4 = 0;
        if (zzkq.SDK_INT < 21) {
            int n5 = (int)(this.zzagt - this.zzagf.zzev() * (long)this.zzagj);
            int n6 = this.zzagl - n5;
            if (n6 > 0 && (n4 = this.zzagg.write(this.zzagy, this.zzagz, n6 = Math.min(this.zzaha, n6))) >= 0) {
                this.zzagz += n4;
            }
        } else {
            int n7 = this.zzaha;
            ByteBuffer byteBuffer2 = byteBuffer;
            n4 = this.zzagg.write(byteBuffer2, n7, 1);
        }
        if (n4 < 0) {
            throw new zzhv(n4);
        }
        this.zzaha -= n4;
        this.zzagt += (long)n4;
        if (this.zzaha == 0) {
            n3 |= 2;
        }
        return n3;
    }

    public final boolean zzer() {
        return this.isInitialized() && (this.zzdn(this.zzagt) > this.zzagf.zzev() || this.zzagf.zzeu());
    }

    public final boolean zzes() {
        return this.zzagt > (long)(this.zzagk * 3 / 2);
    }

    public final void setVolume(float f) {
        this.zzcv = f;
        if (this.isInitialized()) {
            if (zzkq.SDK_INT >= 21) {
                float f2 = f;
                this.zzagg.setVolume(f2);
                return;
            }
            float f3 = f;
            this.zzagg.setStereoVolume(f3, f3);
        }
    }

    public final void pause() {
        if (this.isInitialized()) {
            this.zzet();
            this.zzagg.pause();
        }
    }

    public final void reset() {
        if (this.isInitialized()) {
            this.zzagt = 0L;
            this.zzaha = 0;
            this.zzagv = 0L;
            this.zzagx = 0L;
            this.zzet();
            if (this.zzagg.getPlayState() == 3) {
                this.zzagg.pause();
            }
            AudioTrack audioTrack = this.zzagg;
            this.zzagg = null;
            this.zzagf.zza(null, false);
            this.zzagd.close();
            new zzhr(this, audioTrack).start();
        }
    }

    private final long zzdn(long l) {
        if (this.zzahb) {
            if (this.zzahc == 0) {
                return 0L;
            }
            return (l << 3) * (long)this.zzafv / (long)(1000 * this.zzahc);
        }
        return l / (long)this.zzagj;
    }

    private final long zzdo(long l) {
        return l * 1000000L / (long)this.zzafv;
    }

    private final long zzdp(long l) {
        return l * (long)this.zzafv / 1000000L;
    }

    private final void zzet() {
        this.zzago = 0L;
        this.zzagn = 0;
        this.zzagm = 0;
        this.zzagp = 0L;
        this.zzagq = false;
        this.zzagr = 0L;
    }

    static /* synthetic */ ConditionVariable zza(zzhq zzhq2) {
        return zzhq2.zzagd;
    }
}

