/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzrx;
import com.google.android.gms.internal.ads.zzry;
import com.google.android.gms.internal.ads.zzsb;
import com.google.android.gms.internal.ads.zzsc;
import com.google.android.gms.internal.ads.zzsd;
import com.google.android.gms.internal.ads.zzsj;
import com.google.android.gms.internal.ads.zzsk;
import com.google.android.gms.internal.ads.zzsv;
import com.google.android.gms.internal.ads.zzsy;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class zzsa
implements zzrv {
    private static final Pattern zzapl = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> zzapm = new AtomicReference();
    private final boolean zzapn;
    private final int zzapo;
    private final int zzapp;
    private final String zzapq;
    private final zzsv<String> zzbmk;
    private final zzsd zzbml;
    private final zzsd zzbmm;
    private final zzsj<? super zzsa> zzbmn;
    private zzry zzbmo;
    private HttpURLConnection zzapu;
    private InputStream zzapv;
    private boolean zzapd;
    private long zzapw;
    private long zzapx;
    private long zzapy;
    private long zzce;

    public zzsa(String string2, zzsv<String> zzsv2, zzsj<? super zzsa> zzsj2, int n, int n2, boolean bl, zzsd zzsd2) {
        this.zzapq = zzsk.checkNotEmpty(string2);
        this.zzbmk = null;
        this.zzbmn = zzsj2;
        this.zzbmm = new zzsd();
        this.zzapo = n;
        this.zzapp = n2;
        this.zzapn = true;
        this.zzbml = null;
    }

    @Override
    public final Uri getUri() {
        if (this.zzapu == null) {
            return null;
        }
        return Uri.parse((String)this.zzapu.getURL().toString());
    }

    public final Map<String, List<String>> getResponseHeaders() {
        if (this.zzapu == null) {
            return null;
        }
        return this.zzapu.getHeaderFields();
    }

    @Override
    public final long zza(zzry zzry2) throws zzsb {
        long l;
        int n;
        this.zzbmo = zzry2;
        this.zzce = 0L;
        this.zzapy = 0L;
        try {
            HttpURLConnection httpURLConnection;
            block15: {
                zzry zzry3 = zzry2;
                zzsa zzsa2 = this;
                URL uRL = new URL(zzry3.uri.toString());
                byte[] byArray = zzry3.zzbmd;
                long l2 = zzry3.zzahv;
                long l3 = zzry3.zzcd;
                boolean bl = zzry3.zzbk(1);
                if (!zzsa2.zzapn) {
                    httpURLConnection = zzsa2.zza(uRL, byArray, l2, l3, bl, true);
                } else {
                    int n2 = 0;
                    while (n2++ <= 20) {
                        HttpURLConnection httpURLConnection2 = zzsa2.zza(uRL, byArray, l2, l3, bl, false);
                        int n3 = httpURLConnection2.getResponseCode();
                        if (n3 == 300 || n3 == 301 || n3 == 302 || n3 == 303 || byArray == null && (n3 == 307 || n3 == 308)) {
                            byArray = null;
                            String string2 = httpURLConnection2.getHeaderField("Location");
                            httpURLConnection2.disconnect();
                            String string3 = string2;
                            URL uRL2 = uRL;
                            if (string3 == null) {
                                throw new ProtocolException("Null location redirect");
                            }
                            URL uRL3 = new URL(uRL2, string3);
                            String string4 = uRL3.getProtocol();
                            if (!"https".equals(string4) && !"http".equals(string4)) {
                                String string5 = String.valueOf(string4);
                                throw new ProtocolException(string5.length() != 0 ? "Unsupported protocol redirect: ".concat(string5) : new String("Unsupported protocol redirect: "));
                            }
                            uRL = uRL3;
                            continue;
                        }
                        httpURLConnection = httpURLConnection2;
                        break block15;
                    }
                    int n4 = n2;
                    throw new NoRouteToHostException(new StringBuilder(31).append("Too many redirects: ").append(n4).toString());
                }
            }
            this.zzapu = httpURLConnection;
        }
        catch (IOException iOException) {
            String string6 = String.valueOf(zzry2.uri.toString());
            throw new zzsb(string6.length() != 0 ? "Unable to connect to ".concat(string6) : new String("Unable to connect to "), iOException, zzry2, 1);
        }
        try {
            n = this.zzapu.getResponseCode();
        }
        catch (IOException iOException) {
            this.zzjv();
            String string7 = String.valueOf(zzry2.uri.toString());
            throw new zzsb(string7.length() != 0 ? "Unable to connect to ".concat(string7) : new String("Unable to connect to "), iOException, zzry2, 1);
        }
        if (n < 200 || n > 299) {
            Map<String, List<String>> map = this.zzapu.getHeaderFields();
            this.zzjv();
            zzsc zzsc2 = new zzsc(n, map, zzry2);
            if (n == 416) {
                zzsc2.initCause(new zzrx(0));
            }
            throw zzsc2;
        }
        this.zzapu.getContentType();
        long l4 = this.zzapw = n == 200 && zzry2.zzahv != 0L ? zzry2.zzahv : 0L;
        this.zzapx = !zzry2.zzbk(1) ? (zzry2.zzcd != -1L ? zzry2.zzcd : ((l = zzsa.zzc(this.zzapu)) != -1L ? l - this.zzapw : -1L)) : zzry2.zzcd;
        try {
            this.zzapv = this.zzapu.getInputStream();
        }
        catch (IOException iOException) {
            this.zzjv();
            throw new zzsb(iOException, zzry2, 1);
        }
        this.zzapd = true;
        if (this.zzbmn != null) {
            this.zzbmn.zza(this, zzry2);
        }
        return this.zzapx;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws zzsb {
        try {
            int n3;
            int n4;
            int n5;
            byte[] byArray2;
            zzsa zzsa2 = this;
            if (zzsa2.zzapy != zzsa2.zzapw) {
                byArray2 = zzapm.getAndSet(null);
                if (byArray2 == null) {
                    byArray2 = new byte[4096];
                }
                while (zzsa2.zzapy != zzsa2.zzapw) {
                    n5 = (int)Math.min(zzsa2.zzapw - zzsa2.zzapy, (long)byArray2.length);
                    n4 = zzsa2.zzapv.read(byArray2, 0, n5);
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (n4 == -1) {
                        throw new EOFException();
                    }
                    zzsa2.zzapy += (long)n4;
                    if (zzsa2.zzbmn == null) continue;
                    zzsa2.zzbmn.zzc(zzsa2, n4);
                }
                zzapm.set(byArray2);
            }
            n4 = n2;
            n5 = n;
            byArray2 = byArray;
            zzsa2 = this;
            if (n4 == 0) {
                return 0;
            }
            if (zzsa2.zzapx != -1L) {
                long l = zzsa2.zzapx - zzsa2.zzce;
                if (l == 0L) {
                    return -1;
                }
                n4 = (int)Math.min((long)n4, l);
            }
            if ((n3 = zzsa2.zzapv.read(byArray2, n5, n4)) == -1) {
                if (zzsa2.zzapx != -1L) {
                    throw new EOFException();
                }
                return -1;
            }
            zzsa2.zzce += (long)n3;
            if (zzsa2.zzbmn != null) {
                zzsa2.zzbmn.zzc(zzsa2, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new zzsb(iOException, this.zzbmo, 2);
        }
    }

    @Override
    public final void close() throws zzsb {
        try {
            if (this.zzapv != null) {
                block14: {
                    Object object = this;
                    long l = ((zzsa)object).zzapx == -1L ? ((zzsa)object).zzapx : ((zzsa)object).zzapx - ((zzsa)object).zzce;
                    object = this.zzapu;
                    if (zzsy.SDK_INT == 19 || zzsy.SDK_INT == 20) {
                        InputStream inputStream;
                        try {
                            inputStream = ((URLConnection)object).getInputStream();
                            if (l != -1L ? l <= 2048L : inputStream.read() == -1) break block14;
                        }
                        catch (Exception exception) {}
                        String string2 = inputStream.getClass().getName();
                        if (string2.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string2.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                            Method method = inputStream.getClass().getSuperclass().getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                            method.setAccessible(true);
                            method.invoke((Object)inputStream, new Object[0]);
                        }
                    }
                }
                try {
                    this.zzapv.close();
                }
                catch (IOException iOException) {
                    throw new zzsb(iOException, this.zzbmo, 3);
                }
            }
            this.zzapv = null;
            this.zzjv();
            if (this.zzapd) {
                this.zzapd = false;
                if (this.zzbmn != null) {
                    this.zzbmn.zze(this);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.zzapv = null;
            this.zzjv();
            if (this.zzapd) {
                this.zzapd = false;
                if (this.zzbmn != null) {
                    this.zzbmn.zze(this);
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final HttpURLConnection zza(URL uRL, byte[] byArray, long l, long l2, boolean bl, boolean bl2) throws IOException {
        Object object;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(this.zzapo);
        httpURLConnection.setReadTimeout(this.zzapp);
        for (Map.Entry<String, String> entry : this.zzbmm.zzjw().entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (l != 0L || l2 != -1L) {
            object = new StringBuilder(27).append("bytes=").append(l).append("-").toString();
            if (l2 != -1L) {
                String string2 = String.valueOf(object);
                long l3 = l + l2 - 1L;
                object = new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l3).toString();
            }
            httpURLConnection.setRequestProperty("Range", (String)object);
        }
        httpURLConnection.setRequestProperty("User-Agent", this.zzapq);
        if (!bl) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        }
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setDoOutput(byArray != null);
        if (byArray != null) {
            httpURLConnection.setRequestMethod("POST");
            if (byArray.length != 0) {
                httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                httpURLConnection.connect();
                object = httpURLConnection.getOutputStream();
                ((OutputStream)object).write(byArray);
                ((OutputStream)object).close();
                return httpURLConnection;
            }
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private static long zzc(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string2;
        long l = -1L;
        String string3 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"DefaultHttpDataSource", (String)new StringBuilder(28 + String.valueOf(string3).length()).append("Unexpected Content-Length [").append(string3).append("]").toString());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = zzapl.matcher(string2)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    Log.w((String)"DefaultHttpDataSource", (String)new StringBuilder(26 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Inconsistent headers [").append(string3).append("] [").append(string2).append("]").toString());
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"DefaultHttpDataSource", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("Unexpected Content-Range [").append(string2).append("]").toString());
            }
        }
        return l;
    }

    private final void zzjv() {
        if (this.zzapu != null) {
            try {
                this.zzapu.disconnect();
            }
            catch (Exception exception) {
                Log.e((String)"DefaultHttpDataSource", (String)"Unexpected error while disconnecting", (Throwable)exception);
            }
            this.zzapu = null;
        }
    }
}

